PRO SET_GIF_SCREEN, FILE = filename, $
                    FULL_SCREEN=full_screen, $
                    half_screen = half_screen, $
                    quarter_screen=quarter_screen, $
                    WHITE_BACKGROUND=white, BLACK_BACKGROUND=black, $
                    SWITCH_FOREGROUND_BACKGROUND=switch, $
                    SET_CHARACTER_SIZE=charsize, $
                    sizes=sizes

   COMMON print_file, file_name, prev_device, present_device
   COMMON gif_colors, fore_color, back_color
   COMMON device_char, xsize_c, ysize_c, aspect_ratio
;
;	No required Keywords.
;
; For displaying gifs on screen only
;
;	Parameters:
;		FILENAME = name of file
;               /FULL_SCREEN means full screen size (12 X 14, 72 dpi)
;               /HALF_SCREEN means half screen size (12 X  7, 72 dpi)
;               /QUARTER_SCREEN means quarter screen size (6 X 7, 72 dpi)
;               /WHITE_BACKGROUND  means reverse normal color settings
;               /BLACK_BACKGROUND  means normal settings
;               /SWITCH_FOREGROUND_BACKGROUND  means reverse normal colors
;               SET_CHARACTER_SIZE=[width, line_separation]
;               SIZES=[xsize,ysize] in inches, for 72 dpi
;
;       N.B. This does not work with color yet!!!!
;
;
   PREV_DEVICE0 = !D.NAME
   if (PREV_DEVICE0 NE 'Z') then begin
      SET_PLOT, 'Z'
      present_device = 'gif'
      DEVICE, z_buffering=0
      IF KEYWORD_SET(FILENAME) THEN file_name = filename $
      ELSE file_name = 'idl.gif'
      PREV_DEVICE = PREV_DEVICE0
   ENDIF
   
   IF KEYWORD_SET(FULL_SCREEN) THEN BEGIN
      dpi = 72
      s1 = 12.0
      s2 = 14.0
      charsize0 = [8,12]
   ENDIF ELSE IF KEYWORD_SET(HALF_SCREEN) THEN BEGIN
      dpi = 72
      s1 = 12.0
      s2 = 7.0
      charsize0 = [8,12]
   ENDIF ELSE IF KEYWORD_SET(quarter_screen) THEN BEGIN
      dpi = 72
      s1 = 6.
      s2 = 7.0
      charsize0 = [8,12]
   ENDIF ELSE IF keyword_set(sizes) THEN BEGIN 
      dpi = 72
      s1 = float(sizes(1))
      s2 = float(sizes(0))
      charsize0 = [8,12]
   ENDIF ELSE BEGIN 
      dpi = 72
      s1 = 13.0
      s2 = 14.0
      charsize0 = [8,12]
   ENDELSE 
   
   size1 = dpi*s1
   size2 = dpi*s2
   
   IF (keyword_set(charsize)) THEN BEGIN
      device, set_character_size=charsize
   ENDIF ELSE BEGIN 
      device, set_character_size=charsize0
   ENDELSE 
   
   back_color = !p.background
   fore_color = !p.color
   IF ((keyword_set(white)) OR (keyword_set(switch))) THEN BEGIN
      !p.background = fore_color
      !p.color = back_color
   ENDIF 
   
   xsiz = size2
   ysiz = size1
   device, set_resolution=[xsiz,ysiz]

   xsize_c = xsiz
   ysize_c = ysiz
   aspect_ratio = float(xsize_c)/float(ysize_c)

END



