PRO smart_range_ssm, time, _extrax, extension_percent=extension_percent

;+   
; PROCEDURE: smart_range_ssm
; WRITTEN: 10/27/1998, Pamela A. Puhl-Quinn, ppq@space-theory.physics.uiowa.edu
; USAGE: smart_range, time, _extra, extension_percent=extension_percent
; INPUT: time in seconds since midnight, assumed to be the x-axis
; OUTPUT: _extra structure to be used in plot command for x-axis attributes
;-
   IF keyword_set(extension_percent) THEN factor = extension_percent/100. ELSE factor = .05
   
   delx = time(n_elements(time)-1)-time(0)
   xrange = [min(time)-factor*delx,max(time)+factor*delx]
   xmin = long(time(0)/3600.)
   xmax = long(time(n_elements(time)-1)/3600. + .5)
   xticks = long(xmax-xmin) > 2
   xtickv = (findgen(xticks+1)*(xmax-xmin)/float(xticks) + xmin)*3600.
   xminor = 6

   _extrax = {xrange:xrange, $
              xticks:xticks, $
              xtickv:xtickv, $
              xminor:xminor, $
              xstyle:1, $
              xtickformat:'tick_hms_pam', $
              xtitle:'UT [HH:MM:SS]'}

   return
END


