;+
; NAME: spherical_polar_phi.pro
;
; Given Cartesian x and y components of a vector,
; return the angle phi as defined in spherical polar
; coordinates (i.e. measured from x-axis in the direction of y-axis
; in the x-y plane)
;
; Usage: result = spherical_polar_phi(x,y)
; Note: x and y can be scalars or 1-d arrays of any length
;
; Written: Pamela Puhl-Quinn, University of Iowa
;          1/27/98
;-

FUNCTION spherical_polar_phi, x, y

   x = double(x)
   y = double(y)
   sp_phi = dblarr(n_elements(y))

   sp_phi = atan(y/x)

   first = where(x GE 0 AND y GE 0) ; phi will be positive
   second = where(x LT 0 AND y GE 0) ; phi will be negative
   third = where(x LT 0 AND y LT 0) ; phi will be positive 
   fourth = where(x GE 0 AND y LT 0) ; phi will be negative

   IF first(0) NE -1 THEN sp_phi(first) = sp_phi(first)
   IF second(0) NE -1 THEN sp_phi(second) = sp_phi(second) + !pi
   IF third(0) NE -1 THEN sp_phi(third) = sp_phi(third) + !pi
   IF fourth(0) NE -1 then sp_phi(fourth) = sp_phi(fourth) + 2.d0*!pi

   return, sp_phi
END
