PRO test_gen_fit_release

   print = 0

   npts = 50
   x = dindgen(npts)
   sigma_x = dblarr(npts)+1.
   seed = -2938785
   y = (x*3.76 + 44.5) + 20.*randomn(seed,npts)
   sigma_y = dblarr(npts) + 20.


   gen_fit_release, $
    x=x,sigma_x=sigma_x,y=y,sigma_y=sigma_y, $ 
    titstr='TEST', $ 
    nparms=2, $ 
    slope=slope, intercept=intercept, $ 
    chisq=chisq, rchisq=rchisq, $ 
    c68=c68, c95=c95, c99=c99,$
    ks_c68=ks_c68, ks_c95=ks_c95, ks_c99=ks_c99,$
    force_kappa_search=1,$
    verbose=1,$ 
    kappa_picture=9,$
    status=status, $
    print=print

   !p.multi = [0,1,1]
   window, 0, xsize=600, ysize=600
   plot, x, y, psym=2, ytitle='y', xtitle='x'
   oplot, x, x*slope + intercept, line=3

;=============================================================

   npts = 50
   x = dindgen(npts)
   sigma_x = dblarr(npts)+2.
   seed = -2938785
   y = (x*3.76 + 0.0) + 20.*randomn(seed,npts)
   sigma_y = dblarr(npts) + 30.


   gen_fit_release, $
    x=x,sigma_x=sigma_x,y=y,sigma_y=sigma_y, $ 
    titstr='TEST', $ 
    nparms=1, $ 
    slope=slope, intercept=intercept, $ 
    chisq=chisq, rchisq=rchisq, $ 
    c68=c68, c95=c95, c99=c99,$
    ks_c68=ks_c68, ks_c95=ks_c95, ks_c99=ks_c99,$
    force_kappa_search=1,$
    verbose=1,$ 
    kappa_picture=10,$
    status=status, $
    print=print

   !p.multi = [0,1,1]
   window, 1, xsize=600, ysize=600
   plot, x, y, psym=2, ytitle='y', xtitle='x'
   oplot, x, x*slope + intercept, line=3   

   stop
   return
END
