PRO test_generalized_least_squares_fit

;   MODEL: Third order polynomial in f_1 
;                      (i.e. g = b(0) + b(1)*f_1 + b(2)*f_1^2 + b(3)*f_1^3)
   f_0 = dblarr(100) + 1.d0
   f_1 = dindgen(100)/10.
   f_2 = f_1^2
   f_3 = f_1^3
   seed = -2938785
   g = 68.29 + 3.76*f_1 + 1.4*f_2 + 0.26*f_3 + 5.*randomn(seed,100)
   sigma_g = dblarr(100) + 5.
   sigma_b = 1 ; Must be PREDEFINED to be returned
   inv_accuracy = 1 ; Must be PREDEFINED to be returned
   generalized_least_squares_fit, g, sigma_g, 4, f_0, f_1, f_2, f_3, $
    b=b, sigma_b=sigma_b, rchi2=rchi2, inv_accuracy=inv_accuracy, istat=istat
   print, b
   print, sigma_b
   print, rchi2
   print, inv_accuracy
   print, istat
   !p.multi = [0,1,1]
   plot, f_1, g, psym=2, xtitle='f_1', ytitle='g'
   errplot, f_1, g-sigma_g, g+sigma_g
   oplot, f_1, f_3*b(3) + f_2*b(2) + f_1*b(1) + f_0*b(0), line=3

   res = get_kbrd(1)

;   MODEL: Linear in f_0, intercept=0
;                      (i.e. g = b(0)*f_0)
   f_0 = dindgen(100)
   seed = -2938785
   g = f_0*3.76 + 20.*randomn(seed,100)
   sigma_g = dblarr(100) + 20.
   sigma_b = 1 ; Must be PREDEFINED to be returned
   inv_accuracy = 1 ; Must be PREDEFINED to be returned
   generalized_least_squares_fit, g, sigma_g, 1, f_0, $
    b=b, sigma_b=sigma_b, rchi2=rchi2, inv_accuracy=inv_accuracy, istat=istat
   print, b
   print, sigma_b
   print, rchi2
   print, inv_accuracy
   print, istat
   !p.multi = [0,1,1]
   plot, f_0, g, psym=2, ytitle='g', xtitle='f_0'
   errplot, f_0, g-sigma_g, g+sigma_g
   oplot, f_0, f_0*b, line=3

   stop
   return
END
