pro test_paraboloid_fit

aprime = 1.d0/10.d0^2
bprime = 1.d0/20.d0^2
x0 = 50
y0 = 25
z0 = 5
a = aprime*x0^2+bprime*y0^2+z0
b = -2.d0*aprime*x0
c = -2.d0*bprime*y0
d = aprime
e = bprime
ndata = 100
x_in = (randomu(seed,ndata)*2.d0-1.d0)*200.d0
y_in = (randomu(seed,ndata)*2.d0-1.d0)*200.d0
z_in = a + b*x_in + c*y_in + d*x_in^2 + e*y_in^2
sigma_z_in = make_array(ndata,/double,value=1.d0)
paraboloid_fit, x_in, y_in, z_in, sigma_z_in, $
  aprime=aprime_out, sigma_aprime=sigma_aprime_out, $
  bprime=bprime_out, sigma_bprime=sigma_bprime_out, $
  x0=x0_out, y0=y0_out, z0=z0_out, $
  rchi2=rchi2_out, istat=istat_out
print, aprime, aprime_out, sigma_aprime_out
print, bprime, bprime_out, sigma_bprime_out
print, x0, x0_out
print, y0, y0_out
print, z0, z0_out
print, rchi2_out
print, istat_out

return
end
