pro read_bracket_file, date, iblock, isub, bracket, $
                       model=model, reset=reset, quiet=quiet
;+
;  Read the Bracket file for the given date into the common block,
;  A missing bracket 2 sweep subblock gets initialized to a default.
;
;-
  if keyword_set(quiet) then verbose=0 else verbose=1
  if keyword_set(model) then begin
      common model_bracket, mb
      if not keyword_set(mb) or keyword_set(reset) then begin
          mb= {$
                iblock:iblock, $
                isub:isub, $
                bracket:[-1,-1,1,1]*5e7, $
                prev_bracket:[-1,-1,1,1]*5e7, $
                fp_triangulation:[0L,0L], $
                priority:19., $
                scan_status:-999L, $
                border_status:0L, $
                telescope_status:-999L, $
                status:0L}
      endif
      bracket=mb
      return
  endif

  bracket_dir='/opt/hydra/2sweep_uperp/bracket/'
  bracket_file=bracket_dir+strtrim(date,2)+'_brackets.idlsav'
  lockfile=bracket_file+'.lock'
  status=idl_lockfile(lockfile, wait=30)
  if status eq 0 then begin
      rtry=0
      on_ioerror, bad_restore
      bad_restore: rtry=rtry+1
      if (rtry lt 5) then begin
          restore, bracket_file, verbose=verbose
      endif else begin
          message, 'ERROR opening bracket: bracket file open failed.', /cont
          bracket=-1
          return
      endelse
      status=idl_lockfile(lockfile, /rm)
      if status ne 0 then begin
          message, 'ERROR opening bracket: lockfile rm failed.'
      endif
  endif else begin
      message, 'ERROR opening bracket: lockfile open failed.', /cont
      bracket=-1
      return
  endelse
  if n_elements(brackets) eq 0 then begin
      message, 'ERROR detected reading bracket.', /cont
      bracket=-1
      return
  endif

  r= where( brackets(*).iblock eq iblock and $
            brackets(*).isub eq isub )
  if r(0) eq -1 then begin
      message, 'No bracket found!  Creating default bracket!', /cont
      b1= brackets(0)
      b1.iblock= iblock
      b1.isub= isub
      b1.bracket= [-1,-1,1,1]*500e5
      b1.fp_triangulation= [0,0]
      b1.priority= 19.
      b1.scan_status= -999
      b1.telescope_status= -999
      b1.status=0
      bracket=b1
  endif else begin
      bracket= brackets(r(0))
      if min(bracket.bracket) lt -1e10 then $
        bracket.bracket=[-1,-1,1,1]*500e5
  endelse
  
  return
end

