pro read_ibdata, index, x, y, sigx, sigy, energy, dir=dir
;+
;   Return the interbox data by energy-level index 0-62
;
;   Input: 
;          Index:   Index of save file.
;   Optional:
;          dir:     directory to find files.
;
;   Output:
;          x, y:       Counts for Box 1, Box 2   (Ratio=y/x)
;          sigx, sigy: Uncertainty in x, y
;
;-
if not keyword_set(dir) then $
  dir='/opt/hydra/scratch0/gains/ib/dreicer/'
idlsave_file=dir+'ibdata_'+string(index,format='(i2.2)')+'.idlsav'
f=findfile(idlsave_file, count=nf)
if nf ne 0 then restore, idlsave_file else x=-1
end
