;+
; NAME: html_doc_update.pro
;
; PURPOSE: produce documentation for Iowa IDL codes.
;
; CATEGORY:
;
; CALLING SEQUENCE: html_doc_update
; 
; INPUTS: none
;
; OUTPUTS: produces files in /opt/hydra/web_private_root/code/iowa/
;
; PROCEDURE: uses mk_html_help
;
; EXAMPLE:
;
; MODIFICATION HISTORY: written, Sarah Klemuk, ages ago.
;
;-

;Creates and or updates idl documentation and displays it on website.
;Procedure searches all relevant idl paths.

PRO html_doc_update

dir_str = str_sep(!path,':')
r=n_elements(dir_str)-1
print, r
;if r EQ 12 then begin
;    @/home/sak/idlstartup.pro
;ENDIF
help, dir_str
print, transpose(dir_str)
;do search for /opt/local/lib/rsi/ in dir_str and then exclude these
dir_str_all = dir_str(13:r)

path='/opt/hydra/web_private_root/code/iowa/'
dir_str_level1lib='/opt/hydra/idl_tools/level1lib'
dir_str_access='/opt/hydra/idl_tools/hyd_access'

ndirs=n_elements(dir_str_all)
FOR idir=0,ndirs-1 DO BEGIN
    files=findfile(dir_str_all(idir)+'/*.pro')
    IF (idir eq 0) THEN file_list=files ELSE file_list=[file_list,files]
ENDFOR

spawn, 'mv '+path+'all_codes.html '+path+'all_codes.html.last'
mk_html_help, file_list, path+'all_codes.html', title='Hydra InHouse IDL Documentation'
spawn, 'chmod g+w '+path+'all_codes.html'

;==============================================================
;subgroups of complete alphabetical list

file_level1lib = findfile(dir_str_level1lib+'/*.pro') 
spawn, 'mv '+path+'l1_idl_level1lib.html '+path+'l1_idl_level1lib.html.last'
mk_html_help, file_level1lib, path+'l1_idl_level1lib.html', $
  title='Hydra InHouse IDL Documentation'
spawn, 'chmod g+w '+path+'l1_idl_level1lib.html'

;---------------------------------------------------------------
file_access = findfile(dir_str_access+'/*.pro')
spawn, 'mv '+path+'idl_hyd_access.html '+path+'idl_hyd_access.html.last'
mk_html_help, file_access, path+'idl_hyd_access.html',$
  title='Hydra InHouse IDL Documentation'
spawn, 'chmod g+w '+path+'idl_hyd_access.html'

;==============================================================

end












