pro animate_gifs, filename


  if n_elements( filename ) eq 0 then begin
      filename='*.gif'
  endif

  f= findfile( filename )

  if n_elements(f) eq 0 then begin
      message, 'No matching files found.', /cont
      return
  endif

  read_gif, f(0), d, r, g, b
  tvlct, r, g, b
  w= widget_base( title=filename, /column )
  s= size(d)
  id_draw= widget_draw( w, xsize= s(1), ysize=s(2) )
  id= widget_base( w, /row )
  id_stop= widget_button( id, xsize=50, value='Exit' )
  id_pause= widget_button( id, xsize=50, value='Pause' )
  widget_control, w, /realize
  widget_control, id_draw, get_value=win
  wset, win

  go=1
  i=0
  n= n_elements(f)
  while go do begin
      print, i
      read_gif, f(i), d
      tv, d
      i= (i+1) mod n
      ev= widget_event(w,/nowait)
      if ev.id eq id_stop then begin
          go=0
      endif
      if ev.id eq id_pause then begin
          widget_control, id_pause, set_value='resume'
          ev= widget_event(w)
          widget_control, id_pause, set_value='pause'
      endif
  endwhile
  widget_control, w, /destroy
end





