pro calc_ppa_background, date, time, delta, background, time_out

; I/O:
;  date, a long YYYYMMDD
;  time, a float, decimal hours since midnight.
;  delta, a float, decimal hours.
;  ( time_out, background ) duples are output.

   read_ppa_counts, date, time, delta, counts, viewtime, time_out, $
     ppa_info=ppa_info

   rv= where( viewtime gt 0. )
   rnv= where( viewtime eq 0. )
   
   counts= float(counts)

   rec_count= n_elements( time_out )

   if rv(0) ne -1 then counts(rv)= counts(rv) / viewtime(rv)
   N= make_array( size= size( counts ), /int, value=1 )

   width= ppa_info.width # make_array( value=1, ppa_info.nen * rec_count )   
   N= N*width
   counts= counts*width
   
   if rnv(0) ne -1 then begin
       N(rnv)= 0
       counts(rnv)= 0.
   endif
   
   Sback= total( counts, 1 )
   Nback= total( N, 1 )

   background_level= fltarr( rec_count )
   for i=0, rec_count-1 do begin
       rv= where( Nback(*,i) gt 0 )
       if rv(0) ne -1 then begin
           avg= Sback(rv,i)/Nback(rv,i)
           background_level(i)= min( avg )
       endif else begin
           background_level(i)= 0.
       endelse
   endfor

   background= background_level

   return
end    

