function called_from, name=name, trace=trace
;+
; NAME: called_from
; PURPOSE: returns the name of the procedure that called the current procedure
; CALLING SEQUENCE: name= called_from()
; KEYWORDS: 
;    /name   return just the name
;    /trace  return string array of all the parent routines.
; OUTPUTS: returns string that is the procedure name of the parent.
; PROCEDURE: use the calls keyword for help to get the trace history,
;    then return the first element.
; EXAMPLE: print, 'routine called by '+called_from()
; MODIFICATION HISTORY: written, jbf, Oct 6, 1998.
;-
   help, calls=a
   s= str_sep(a(2),' ')
   if keyword_set(name) then begin
       return, s(0) 
   endif else if keyword_set(trace) then begin
       names=strarr(n_elements(a)-1)
       for i=1,n_elements(a)-1 do begin
           s= str_sep(a(i),' ')
           names(i-1)= s(0)
       endfor
       return, names
   endif else begin
       return, a(2)
   endelse
end



