pro test_event, event
   widget_control, widget_info( event.top, /child ), get_uvalue= test_state
   widget_control, event.id, get_uvalue=uval
   if uval eq 'quit' then begin
       widget_control, test_state.cw_hydra_findfile_id, get_value=value
       print, value
       widget_control, event.top, /destroy
   endif
end

pro test
   w= widget_base( title='Test of cw_hydra_findfile', /column )
   x= widget_base( w )
   cw_hydra_findfile_id= $
     cw_hydra_findfile( w, uvalue='cw_hydra_findfile', /moments, $
                        date='19960529' )
   x= widget_button( w, value='Quit', uvalue='quit' )
   
   test_state= { cw_hydra_findfile_id:cw_hydra_findfile_id }
   widget_control, widget_info( w, /child ), set_uvalue=test_state
   widget_control, w, /realize
   xmanager, 'test', w 
end

function cw_hydra_findfile_get, base  
   widget_control, widget_info( base, /child ), get_uvalue=state
   return, state.filename
end

pro cw_hydra_findfile_set, base, value
   widget_control, widget_info( base, /child ), get_uvalue=state
   state.filename=value
   widget_control, widget_info( base, /child ), set_uvalue=state 
   return
end

function cw_hydra_findfile_event, event
   widget_control, widget_info( event.handler, /child ), get_uvalue=state
   widget_control, event.id, get_uvalue=uval
   generate_event=0
   case uval of
       'help': begin
           str=[ $
                 'hydra_findfile widget', $
                 '', $
                 'Enter a filename and return in the text widget to ', $
                 'specify explicitly which file to use.  (Otherwise, ', $
                 'file is located automatically.)  Entering a date in this', $
                 'widget resets the "context date," which is the date for', $
                 'which we want data.', $
                 '', $
                 'Pressing "Find" causes hydra_findfile to locate the ', $
                 'data file for the context date.  This result is printed', $
                 'in the text widget.  If you wish to explicitly specify ', $
                 'that this file should be used, delete "Found:" and press', $
                 'enter.', $
                 '', $
                 'Pressing "Browse" raises a IDL pickfile widget.  It may', $
                 'be used to select the data file as well.', $
                 '' ]
           x= widget_message( str, /info )
       end
       'filename': begin
           widget_control, event.id, get_value=filename
           filename= filename(0)
           hyd_file_status, filename, read=read
           if not read then begin
               if filename ne '' then begin
                   f= findfile(filename,count=count) 
                   if count gt 0 then filename=f(count-1) else begin
                       if max( byte( filename ), min=min ) le (byte('A'))(0) $
                         then begin
                           date= gen_time_string(long(gen_time(date=filename)))
                           widget_control, state.text_id, $
                             set_value='Date Context='+date
                           state.date= date                           
                           filename=''
                       endif else begin
                           filename=''
                           widget_control, state.text_id,set_value='File not found'
                       endelse
                   endelse
               endif
           endif 
           state.filename= filename
           generate_event=1
           if filename ne '' then $
             widget_control, state.text_id, set_value=filename
       end
       'browse': begin
           filename= pickfile(path=state.pwd,get_path=pwd,filter=state.filter)
           state.pwd=pwd
           if filename ne '' then begin
               hyd_file_status, filename, read=read
               if not read then begin
                   f= findfile(filename,count=count) 
                   if count gt 0 then filename=f(count-1) else begin
                       filename=''
                       widget_control, state.text_id,set_value='File not found'
                   endelse
               endif 
               state.filename= filename
               generate_event=1
               if filename ne '' then $
                 widget_control, state.text_id, set_value=filename
           endif
       end
       'find': begin
           if state.date eq '' then begin
               widget_control, state.text_id, $
                 set_value='No date specified.  To specify date, '+$
                 'enter YYYYMMDD and hit return'
           endif else begin
               filename= hydra_findfile( state.date, $
                                         _extra= state.findfile_kw )
               if filename eq '' then begin
                   widget_control, state.text_id, set_value='No files found'
               endif else begin
                   widget_control, state.text_id, set_value='Found: '+filename
               endelse
           endelse
       end
   endcase
   widget_control, widget_info( event.handler, /child ), set_uvalue=state    
   
   if state.events and generate_event then begin
       event= { id:event.handler, $
                top:event.top, $
                handler:event.handler, $
                value:state.filename }
       return, event
   endif else return, -1
end

function cw_hydra_findfile, parent, row=row, column=column, $
                            xsize=xsize, events=events, _extra=e, $
                            date=date, filename=file, $
                            survey=survey, level1=level1, ddcal=ddcal, $
                            moments_all=moments_all

   if n_elements( xsize ) eq 0 then xsize=40
   if n_elements( date ) eq 0 then date=''
   if n_elements( file ) eq 0 then file=''

   b0= widget_base( parent, /frame, $
                    event_func='cw_hydra_findfile_event', $
                    pro_set_value='cw_hydra_findfile_set', $
                    func_get_value='cw_hydra_findfile_get', /column, $
                    _extra=e )
   x= widget_base(b0)
   b1= widget_base( b0, /row )
   text_id= widget_text( b1, value='', xsize=xsize, /editable, $
                         uvalue='filename' )
   widget_control, text_id, set_value=file
   x= widget_button( b1, value='Browse', uvalue='browse' )
   x= widget_button( b1, value='Find', uvalue='find' )
   x= widget_button( b1, value='?', uvalue='help' )
   findfile_kw= { survey:keyword_set(survey), $
                  level1:keyword_set(level1), $
                  ddcal:keyword_set(ddcal), $
                  moments_all:keyword_set(moments_all) }
   case 1 of 
       findfile_kw.survey: begin
           envar= 'HYDRA_SURVEY_DATA_PATH'
           filter= '*_hyd_sv_v*.cdf'
       end
       findfile_kw.level1: begin
           envar= 'HYDRA_LEVEL1_DATA_PATH'
           filter= '*_hyd_dd_v*.cdf'
       end
       findfile_kw.ddcal: begin
           envar= 'HYDRA_DDCAL_DATA_PATH'
           filter= '*_hyd_ddcal_v*.cdf'
       end
       findfile_kw.moments_all: begin
           envar= 'HYDRA_MOMENTS_DATA_PATH'
           filter= '*_hyd_mom_v*.cdf'
       end
       else: message, 'Type not specified.'
   endcase

   path= getenv(envar)

   pwd='./'
   
   state= { filename:file, date:date, findfile_kw:findfile_kw, $
            pwd:pwd, envar:envar, filter:filter, $
            events:keyword_set(events), text_id:text_id }
   widget_control, widget_info(b0,/child), set_uvalue=state
   return, b0
end




