pro hyd_gt_colorbar, v, red, green, blue, $
                     ctable=ctable, $
                     zlog=zlog, $
                     zrange=zrange

  on_error, 2
  
  common hydra_setcolors1_common, cs_common
  if n_elements(ctable) eq 0 then begin
      if n_elements( cs_common ) eq 0 then begin
          message, 'ctable must be specified if hydra_setcolors is not active'
      endif
      ctable=cs_common.colortable
  endif
  rr= red
  gg= green
  bb= blue
  yy= v
  n= ctable(1)-ctable(0)+1
  if n_elements( zrange ) eq 0 then begin
      message, 'zrange must be specified.'
  endif
  cbar_range= zrange
  if keyword_set(zlog) then begin
      yy=alog10(yy)
      cbar_range= alog10(cbar_range)
  endif
  
  yyy= findgen(n)/(n-1)*(cbar_range(1)-cbar_range(0)) + cbar_range(0)
  ifindex= hyd_findex( yy, yyy )
  tvlct, /get, r, g, b
  r(ctable(0))= interpolate(rr,ifindex)
  g(ctable(0))= interpolate(gg,ifindex)
  b(ctable(0))= interpolate(bb,ifindex)
  tvlct, r, g, b
end
