;+
; NAME: hyd_interactive
;   
; PURPOSE:
;   returns 1 if the code is being run in an interactive environment
;   (e.g. papco) and widget dialog messages can be presented to a human.
;
; CATEGORY:
;
; CALLING SEQUENCE:
;   x= hyd_interactive()
;
; INPUTS:
;   none
;
; OPTIONAL INPUTS:
;   the environment variable 'hyd_interactive' will explicitly set
;   the output.
;
; KEYWORD PARAMETERS:
;   dialog_parent=dialog_parent    return a guess of the parent id of the
;                                  interactive widget
;
; OUTPUTS:
;   1   interactive mode (human can be solicited for information or
;                         presented with information)
;   0   batch mode (no human present)
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;   Only detects papco.  
;
; PROCEDURE:
;   sense weight of human fingers on keyboard, and if that fails,
;   check to see if there are any active widgets.
;   
; EXAMPLE:
;   if hyd_interactive() then begin
;     x= widget_message('press okay to continue')
;   endif
;
; MODIFICATION HISTORY:
;   written, jbf, August 1, 2002.
;-


function hyd_interactive, dialog_parent=dialog_parent

  dialog_parent=0
  interactive= widget_info(/active)
  
  if interactive then begin
      managed= widget_info( /managed )
      dialog_parent= managed[n_elements(managed)-1]
  endif

  return, interactive

end
