;+
; NAME: hyd_intersection
;
; PURPOSE: return the indeces that are in both groups
;
; CATEGORY:
;
; CALLING SEQUENCE: hyd_intersection, A, B, idxA, idxB
; 
; INPUTS: 
;   A,B    1-D arrays that are lonarr's
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;   returns long arr of the indeces that match for each array
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;   Arrays must be monotonically increasing and each element must
;    be unique.
;
; PROCEDURE:
;   divide and conquer: find splitting point, then recurse.
;
; EXAMPLE:
;   A= [ 1,2,3,4,5 ]
;   B= [ 4,5,6,7,8 ]
;   hyd_intersection, A,B,rA,rB
;   print, A[rA],B[rB]
;   A= long( randomu(s,100000)*100000 )
;   A= A[uniq( A, sort(A) )]
;   B= long( randomu(s,100000)*100000 )
;   B= B[uniq( B, sort(B) )]
;   hyd_intersection, A, B, rA, rB
;   plot, A[rA] - B[rB]
;
; MODIFICATION HISTORY:
;   written, jbf, UI, May 3, 2002.
;-

pro hyd_intersection, A, B, ra, rb
  max= max( [ A, B ], min=min ) 
  if double(max) - double(min) gt 10000 then begin

      middle= ( double(max) + double(min) ) / 2 
      ra0= where( A le middle )
      rb0= where( B le middle )
      ra1= where( A gt middle ) 
      rb1= where( B gt middle ) 

      if ra0[0] ne -1 and rb0[0] ne -1 then begin
          hyd_intersection, A[ra0], B[rb0], rra0, rrb0          
      endif else begin
          rra0= -1
          rrb0= -1
      endelse

      if ra1[0] ne -1 and rb1[0] ne -1 then begin
          hyd_intersection, A[ra1], B[rb1], rra1, rrb1
      endif else begin
          rra1= -1
          rrb1= -1
      endelse

      case (1) of
          rra0[0] ne -1   and  rra1[0] ne -1: ra= [ ra0[rra0], ra1[rra1] ]
          rra0[0] ne -1   and  rra1[0] eq -1: ra= ra0[rra0]
          rra0[0] eq -1   and  rra1[0] ne -1: ra= ra1[rra1] 
          rra0[0] eq -1   and  rra1[0] eq -1: ra= -1
      endcase
      
      case 1 of
          rrb0[0] ne -1   and  rrb1[0] ne -1: rb= [ rb0[rrb0], rb1[rrb1] ]
          rrb0[0] ne -1   and  rrb1[0] eq -1: rb= rb0[rrb0]
          rrb0[0] eq -1   and  rrb1[0] ne -1: rb= rb1[rrb1] 
          rrb0[0] eq -1   and  rrb1[0] eq -1: rb= -1
      endcase
          
      r= where( ra ne -1 ) 
      if r[0] eq -1 then ra=-1 else ra=ra[r]

      r= where( rb ne -1 ) 
      if r[0] eq -1 then rb=-1 else rb=rb[r]

  endif else begin

      hitarr= bytarr( max-min+1 )
      hitarr[A-min]= hitarr[A-min]+1
      hitarr[B-min]= hitarr[B-min]+1
      ra= where( hitarr[A-min] eq 2 )
      rb= where( hitarr[B-min] eq 2 )

  endelse
  
  return
end
  

