pro hyd_progress_bar, id, $
                      percent, $
                      kill=kill, $
                      destroy=destroy, $
                      title=title, $
                      dialog_parent=dialog_parent

  return  
  if !d.name eq 'Z' then return
      
  if keyword_set(kill) then destroy=1

  xsize=300
  ysize=5

  if n_elements(id) eq 0 then id=-1L
  
  if n_elements(title) eq 0 then title= called_from()
  if widget_info( id, /valid ) eq 0 and $
    not keyword_set(kill) then begin
      
      id= widget_base( title='Progress', /col )
      child= widget_base( id )
      id_title= widget_label( id, value=title, /align_left )
      id_draw= widget_draw( id, xsize=xsize, ysize=ysize )

      widgetData= { id:id, $
                    id_title:id_title, $
                    title:title, $
                    id_draw:id_draw, $
                    color:-1L, $
                    background:-1L $
                  }
      if n_elements( dialog_parent ) eq 0 then begin
          widget_center, id
      endif else begin
      endelse
      
      widget_control, id, /realize

      widget_control, child, set_uvalue= widgetData      

  endif else begin
      
      if keyword_set( kill ) then begin
          widget_control, id, /destroy
          return
      endif else begin
          child= widget_info( id, /child )
          widget_control, child, get_uvalue= widgetData
      endelse
      
  endelse
  
  oldwindow= !d.window
  widget_control, widgetData.id_draw, get_value=window
  wset, window

  if widgetData.color eq -1 then begin
      widgetData.color= get_color_index('red')
      widgetData.background= get_color_index('white')
      if widgetData.color eq widgetData.background then begin
          widgetData.background= !p.background
          widgetData.color= !p.color
      endif
      widget_control, child, set_uvalue= widgetData
  endif
  
  erase, color=widgetData.background
  polyfill, /device, [0,0,1,1,0]*percent*xsize, $
    [0,1,1,0,0]*ysize, color=widgetData.color

  if keyword_set(title) then begin
      if title ne widgetData.title then begin
          widget_control, widgetData.id_title, set_value= title
      endif
  endif

  wset, oldwindow
end
      
  
