pro hyd_scatter, x_in, y_in, z_in, dots=dots, $
                 xrange=xrange_in, xlog=xlog, $
                 yrange=yrange_in, ylog=ylog, $
                 zrange=zrange_in, zlog=zlog, psym=psym, symsize=symsize, $
                 ctable=ctable, $
                 draw_colorbar=draw_colorbar, inset_colorbar=cbar_inset, $
                 cbar_xpos=cbar_xpos, $
                 cbar_title=zword, ztitle=ztitle, $
                 overplot=overplot, $
                 min_value=min_value, max_value=max_value, $
                 _extra=e

  check_plotparms, _extra=e

  on_error, 2
;    emulate plot keyword defaults
    if n_elements( xlog ) eq 0 then xlog=0
    if n_elements( ylog ) eq 0 then ylog=0
    if n_elements( xrange_in ) eq 0 then xrange_in=[0,0]
    if n_elements( yrange_in ) eq 0 then yrange_in=[0,0]    

;    draw axes and set plot coordinates
    if not keyword_set( overplot ) then $
      plot, x_in, y_in, /nodata,$
      xlog=xlog, ylog=ylog, $
      xrange=xrange_in, yrange=yrange_in, $
      _extra=e

;    handle keywords
    if n_elements(z_in) eq 0 then z_in= x*0.+1

    if n_elements(zrange_in) eq 0 then begin
        r= lindgen(n_elements( z_in ))

        if n_elements( min_value ) eq 1 and r(0) ne -1 then begin
            r1= where( z_in(r) ge min_value )
            if r1(0) eq -1 then r=-1 else r= r(r1)
        endif

        if n_elements( max_value ) eq 1 and r(0) ne -1 then begin
            r1= where( z_in(r) le max_value )
            if r1(0) eq -1 then r=-1 else r= r(r1)
        endif
 
        if r(0) ne -1 then $
          zrange_in= [ min(z_in(r)), max(z_in(r)) ] $
        else $
          zrange_in= [ 0,1 ]
    endif
    
    if keyword_set(zlog) then begin
        z= alog10(double(z_in))
        zrange= alog10(double(zrange_in))
    endif else begin
        z= double(z_in)
        zrange= double(zrange_in)
    endelse

    if !x.type then begin
        x= alog10(x_in)
        if min(xrange_in) gt 0 then $
          xrange= alog10(xrange_in)
    endif else begin
        x= x_in
        xrange= xrange_in
    endelse

    if !y.type then begin
        y= alog10(y_in)
        if min(yrange_in) gt 0 then $
          yrange= alog10(yrange_in)
    endif else begin
        y= y_in
        yrange= yrange_in
    endelse
    
    if n_elements( symsize ) eq 0 then symsize=!p.symsize
    if n_elements( ctable ) eq 0 then begin
        hydra_setcolors, cs
        ctable= cs.colortable
    endif
    base= ctable(0)
    ncol= ctable(1)-ctable(0)+1

    zcolor= bytscl( z, min=zrange(0), max=zrange(1), top= ncol ) + $
      base < ctable(1) > ctable(0)
    
;    handle psym
    if keyword_set(dots) then begin
        usersym, cos( findgen(12)/2 )*dots, sin( findgen(12)/2)*dots, /fill
        psym=8
    endif
    if n_elements( psym ) eq 0 then psym=1

;    clip points out of field and plot data
    r=where( x gt !x.crange(0) and x lt !x.crange(1) and $
             y gt !y.crange(0) and y lt !y.crange(1) )

    if n_elements( min_value ) eq 1 and r(0) ne -1 then begin
        r1= where( z(r) ge min_value )
        if r1(0) eq -1 then r=-1 else r= r(r1)
    endif

    if n_elements( max_value ) eq 1 and r(0) ne -1 then begin
        r1= where( z(r) le max_value )
        if r1(0) eq -1 then r=-1 else r= r(r1)
    endif
    
    if r(0) ne -1 then $
      plots, x_in(r), y_in(r), color=zcolor(r), psym=psym, symsize=symsize


    !z.crange= zrange

    if keyword_set( draw_colorbar ) then begin
        hydra_colorbar, zrange=zrange_in, zlog=zlog, $
          xpos= cbar_xpos, zword= zword, ztitle= ztitle, ctable=ctable, /no_tv
    endif
    
    if n_elements( cbar_inset ) then begin
        hydra_colorbar, zrange=zrange_in, zlog=zlog, $
          inset= cbar_inset, zword= zword, ztitle= ztitle, ctable=ctable, /no_tv
    endif
 
    return
end
    
       
   
