;pro testit
;  x= randomu(s,40)*!pi*2
;  y= 10^(randomu(s,40)*3+1)
;  z= 10.d^(-y/100)
;  x= [x-!pi*2,x,x+!pi*2]
;  y= [y,y,y]
;  z= [z,z,z]

;  dots, /fill
  
;  !p.multi=[0,1,3]
  
;  hyd_scatter, x, y, z, psym=8, /zlog
  
;  triangulate, x, y, T

;  grid1= hyd_trigrid( x, alog10(y), alog10(z), T, $
;                      [!pi/100,alog10(20000/10.)/110], $
;                      [0.,alog10(10),2*!pi,alog10(10000)], $
;                      ygrid=ygrid1, missing=-1e31, xgrid=xgrid )
;  r= where( grid1 gt -1e30 )
;  range=[min(grid1(r),max=max),max] 
;  plot, 10^ygrid1, grid1(0,*), psym=3, yrange=range
;  for ix= 1,n_elements(xgrid)-1 do begin
;      oplot, 10^ygrid1, grid1(ix,*), psym=3      
;  endfor
  
;  grid2= hyd_trigrid( x, y, alog10(z), T, $
;                      [!pi/10,alog10(20000/10.)/111], [0.,10,2*!pi,10000], $
;                      ygrid=ygrid2, $
;                      /ylog, missing=-1e31, xgrid=xgrid )
;  plot, ygrid2, grid2(0,*), psym=3, yrange=range
;  for ix= 1,n_elements(xgrid)-1 do begin
;      oplot, ygrid2, grid2(ix,*), psym=3
;  endfor

;  stop
;end

function hyd_trigrid, x, y, z, T, $
                      gs, limits_in, ylog=ylog, _extra=e, $
                      yloc=yloc, $
                      ygrid=ygrid, xgrid=xgrid
;+
; NAME: hyd_trigrid
;
; PURPOSE: like trigrid, but can interpolate to a logarithmic grid.
;
; CATEGORY: utility
;
; CALLING SEQUENCE: result= hyd_trigrid( x, y, z, T, gs, limits )
; 
; INPUTS: 
;    x,y,z    buckshot data
;    T        triangulation of x and y.
;    gs       [dx,dy] grid spacing.  If /ylog, then dy= alog10(y2/y1)
;    limits   [minx,miny,maxx,maxy]
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;    /ylog      rows of returned grid should have logarithmic spacing in y.
;    yloc=fltarr(ny)  rows of returned grid should be interpolated at
;                      these points.  limits([1,3]) are ignored.
;    ygrid=out  return the y names for each row of returned grid.
;    xgrid=out  return the x names for each column of returned grid.
;
; OUTPUTS:
;    returns  fltarr(nx,ny) or dblarr(nx,ny), where 
;                 nx= long((limits[2]-limits[0])/gs[0])+1    and
;                 ny= long((limits[3]-limits[1])/gs[1])+1   (ylog=0)
;
; OPTIONAL OUTPUTS: none
;
; COMMON BLOCKS: none
;
; SIDE EFFECTS: none
;
; RESTRICTIONS: assumes that limits are sensible for /ylogq
;
; PROCEDURE: 
;   ylog=0: simply call trigrid.
;   ylog=1: form ygrid, 
;           loop over pairs of ygrid
;              form limits1, gs1 that intersect with two ygrid points.
;              call trigrid and put into result array.
;           endloop.
;   yloc:   set ygrid= yloc, proceed as with ylog=1.
;
; EXAMPLE:
;  x= randomu(s,40)*!pi*2
;  y= 10^(randomu(s,40)*3+1)
;  z= 10.d^(-y/100)
;  x= [x-!pi*2,x,x+!pi*2]
;  y= [y,y,y]
;  z= [z,z,z]
;  triangulate, x, y, T
;  hyd_scatter, x, y, z
;  grid= hyd_trigrid( x, y, alog10(z), T, $
;                     [!pi/10,alog10(20000/10.)/110], [0.,10,2*!pi,10000], $
;                     ygrid=ygrid, $
;                     /ylog, missing=-1e31, xgrid=xgrid )
;
;  plot, ygrid, grid(0,*), psym=3, yrange=!z.crange
;  for ix= 1,n_elements(xgrid)-1 do $
;     oplot, ygrid, grid(ix,*), psym=3
; 
; MODIFICATION HISTORY:
; written, Wed Mar  7 11:50:45 CST 2001, jbf, UIowa.
;-
                      
  if not keyword_set(ylog) and n_elements(yloc) eq 0 then begin
      return, trigrid( x, y, z, T, gs, limits_in, ygrid=ygrid, _extra=e, $
                       xgrid=xgrid )
  endif else begin
      limits= limits_in

      if n_elements( yloc ) gt 0 then begin
          yarr= yloc
          ny= n_elements( yloc )
      endif else begin
          limits[1]= alog10(limits[1])
          limits[3]= alog10(limits[3])
          ny= long((limits[3]-limits[1])/gs[1]+0.1)+1
          yarr= 10^ (dindgen(ny) * gs[1] + limits[1])
      endelse

      nx= long((limits[2]-limits[0])/gs[0]+0.1)+1

      result= make_array( nx, ny, type=size(x,/type) )
      iyarr=0
      while (iyarr lt n_elements(yarr)) do begin
          if iyarr eq n_elements(yarr)-1 then iyarr= iyarr-1  ;odd n_ele(yarr)
          ylow= yarr[iyarr] 
          yhigh= yarr[iyarr+1] 
          gs1= [ gs[0],yhigh-ylow ]
          if gs1[1] lt 1e-5 then begin
              gs1[1]= 1e-5
              istep=1
              limits1= [limits[0],ylow,limits[2],yhigh*1.0001] 
              result[*,iyarr]= $
                ( trigrid( x, y, z, T, $
                           gs1, limits1, xgrid=xgrid, _extra=e ) ) [ *,0 ]
          endif else begin
              istep=2
              limits1= [limits[0],ylow,limits[2],yhigh*1.0001] 
              result[*,iyarr:(iyarr+1)]= $
                ( trigrid( x, y, z, T, $
                           gs1, limits1, xgrid=xgrid, _extra=e ) ) [ *,0:1 ]
          endelse         
          iyarr= iyarr+istep
      endwhile

      ygrid= yarr

      return, result

  endelse
end
  
  
