pro testit
  set_plot, 'ps'
  device, /color, bits=8
  device, filename='idlXXX.ps'
  hyd_tv, dist(15), 1, 1, xsize=1, ysize=1, /inches
  device, /close
  device, filename='idl300.ps'
  hyd_tv, dist(15), 1, 1, xsize=1, ysize=1, /inches, agu=1
  device, /close
end


pro hyd_tv, image_in, x, y, $
            xsize=xsize, ysize=ysize, $
            inches=inches, centimeters=centimeters, normal=normal, $     
            _extra=e, agu=agu
  
  if getenv('hyd_agu') eq '1' then agu=1
  agu= keyword_set(agu)

  inches= keyword_set(inches)
  centimeters= keyword_set(centimeters)

  if n_elements(x) eq 0 then x=0
  if n_elements(y) eq 0 then y=0

;  If AGU mode is set, then resample the image to be 300 dpi  
  if agu and !d.name eq 'PS' and $
    ( inches or centimeters or n_elements(normal) ) $
    then begin
      dpi= 300      
      if centimeters then begin
          xinches= xsize/2.54
          yinches= ysize/2.54
      endif else if n_elements(normal) ne 0 then begin 
          xinches= xsize * !d.x_size / !d.x_px_cm / 2.54
          yinches= ysize * !d.y_size / !d.y_px_cm / 2.54
      endif else begin
          xinches= xsize
          yinches= ysize
      endelse

;       expand out x and y dimensions of the image to 300 dpi, unless
;       we already have at least 300 dpi.
      s= size( image_in )
      xpixels= xinches * dpi > s[1]
      ypixels= yinches * dpi > s[2]
      if xpixels gt s[1] or ypixels gt s[2] then begin
          message, 'Resampling image to 300 dpi for AGU mode.', /cont
      endif
      image= congrid( image_in, xpixels, ypixels )
  endif else begin
      image= image_in      
  endelse

  tv, image, x, y, $
    xsize=xsize, ysize=ysize, $
    inches=inches, $
    centimeters=centimeters, $
    normal=normal, $
    _extra=e

end
