function hydra_hms, time_arr, secformat=secformat
;  converts time in seconds since midnight (or T90) to a string in the form,
;  'HH:MM:SS' or as specified by format.
   
   ret= strarr( n_elements( time_arr ) )
   for i=0,n_elements(time_arr)-1 do begin
       time= time_arr(i)
       t= (time) mod 86400
       hour = fix(t/3600.)
       minute = (t mod 3600)/60
       if not keyword_set( secformat ) then begin
           secformat='i2.2' 
           sec= fix ( (t mod 60) + 0.5 )
       endif else begin
           sec= t mod 60.
       endelse
       ret(i)= $
         string(hour,minute,sec, format="(i2.2,':',i2.2,':',"+secformat+")") 
   endfor
   
   if (size(time_arr))(0) gt 0 then begin
       return, ret
   endif else begin
       return, ret(0) 
   endelse
end
