pro hydra_time_conv, date=date_in, time=time_in, $
                     ssm=ssm, $ ; time is in seconds since midnight
                     yyyymmdd_out= date_out, $
                     dh_out=time_out, $
                     year_out=year, month_out=month, day_out=day, $
                     hour_out=hour, minute_out=minute, second_out=second, $
                     doy96_out=doy96

       
   date= date_in
   time= time_in

   if n_elements(time) eq 0 then time=0

;  date is forced to YYYYMMDD
   date=strtrim(date,2)
   if strlen(date) eq 6 then date='19'+date
   if strlen(date) eq 4 then date='19'+date+'01'
   if strpos(date,'y') ne -1 then begin ; YYYYyDOY
       ss= strpos(date,'y')
       year= fix(date)
       if year lt 100 then year=year+1900
       if year lt 1990 then year=year+100
       doy= fix(strmid(date,ss+1,99))
       
       case 1 of
           ( doy gt 366 ) and ( doy le 731 ) : begin
               doy= doy-366
               year= year+1
           end
           ( doy gt 731 ) and ( doy le 1096 ) : begin
               doy= doy-731
               year= year+2
           end
           ( doy gt 1096 ) and ( doy le 1461 ) : begin
               doy= doy-1096
               year= year+3
           end
           ( doy gt 1461 ) and ( doy le 1827 ) : begin
               doy= doy-1461
               year= year+4
           end
           else:
       endcase

       year_month_day, year, doy, mon, day
       date_out= strtrim(year,2)+string(mon,format='(i2.2)')+$
         string(day,format=('(i2.2)'))
   endif

;  time is forced to HH.HHH, a double
   if keyword_set( ssm) then begin
       time= time/3600.
   endif else begin
       timef=strtrim(time,2)   
       if strpos(timef,'.') eq -1 then begin
           if strpos(timef,':') eq -1 then begin  
               case strlen(timef) of
                   1: timef= '0'+timef+'0000' ; H
                   2: timef= timef+'0000' ; HH
                   3: timef= '0'+timef+'00' ; HMM
                   4: timef= timef+'00' ; HHMM
                   5: timef= '0'+timef ; HMMSS
                   6: timef= timef ; HHMMSS
                   else: time=complex(-1) ; flag an error
               endcase
           endif else begin
               case strlen(timef) of
                   8: timef= strmid(timef,0,2)+strmid(timef,3,2)+strmid(timef,6,2) 
                                ; HH:MM:SS
                   5: timef= strmid(timef,0,2)+strmid(timef,3,2)+'00' ; HH:MM
                   else: dh_out=complex(-1) ; flag an error
               endcase
           endelse
       endif
   endelse

   type= (size(time))(1)
   if (type eq 1 or type eq 2 or type eq 3 or type eq 7) then begin
       dh_out= double( strmid(timef,0,2) ) + $
         double( strmid(timef,2,2) ) / 60. + $
         double( strmid(timef,4,2) ) / 3600.
   endif else if (type eq 4) or (type eq 5)  then begin
       dh_out= double(time)
   endif else begin
       print, 'Error in time format.  Use any of '
       print, 'HH:MM:SS, HHMMSS, HH:MM, HHMM, HH.HHH, HH'
       stop, ' '
   endelse

   month= fix(strmid(date,4,2))
   day= fix(strmid(date,6,2))
   year= fix(strmid(date,0,4))
   hour= fix(time)
   minute= fix( ( time - hour ) * 60 )
   second= fix( ( time - hour - minute/60. ) * 3600 )

   doy= hyd_day_of_year( year, month, day )
   case year of 
       1996: doy96= doy
       1997: doy96= doy+366
       1998: doy96= doy+366+365
       1999: doy96= doy+366+365+365
       2000: doy96= doy+366+365+365+365
       2001: doy96= doy+366+365+365+365+366
       2002: doy96= doy+366+365+365+365+366+365
       else: print, 'Less than 2002, please'
   endcase

   doy96= doy96 + dh_out / 24.

   return
end
