pro hydra_time_io, date, time, year, month, day, hour, minute, second, $
                   doy96=doy96, doy=doy

   if n_params() eq 0 then begin
       print, 'pro hydra_time_io, date, time, [year, month, day, hour, minute, second]'
       print, '   date, time   are input and output '
       print, '   year, month, day, hour, minute, second are optional output'
   endif
       
   if n_elements(time) eq 0 then time=0

;  date is forced to YYYYMMDD
   date=strtrim(date,2)
   if strlen(date) eq 4 then date=date+'01'

   if strpos(date,'y') ne -1 then begin ; YYYYyDOY
       ss= strpos(date,'y')
       year= fix(date)
       if year lt 90 then year= year+2000
       if year lt 100 and year ge 90 then year=year+1900       
       if year lt 1990 then year=year+100
       doy= fix(strmid(date,ss+1,99))
       
       dd= doy
       while dd gt 366 do begin
           days= julday( 12, 31, year ) - 2450083
           dd= doy-days
           year=year+1
       endwhile
       doy= dd

       julian= julday( 1, 1, year ) - 1  + doy
       caldat, julian, mon, day, year

;       case 1 of
;           ( doy gt 366 ) and ( doy le 731 ) : begin
;               doy= doy-366
;               year= year+1
;           end
;           ( doy gt 731 ) and ( doy le 1096 ) : begin
;               doy= doy-731
;               year= year+2
;           end
;           ( doy gt 1096 ) and ( doy le 1461 ) : begin
;               doy= doy-1096
;               year= year+3
;           end
;           ( doy gt 1461 ) and ( doy le 1827 ) : begin
;               doy= doy-1461
;               year= year+4
;           end
;           else:
;       endcase

       date= strtrim(year,2)+string(mon,format='(i2.2)')+$
         string(day,format=('(i2.2)'))
   endif

   if strlen(date) le 6 then begin
       idate= long( date )
       if idate lt 900000 then idate= idate+20000000 else idate=idate+19000000
       date= strtrim( idate, 2 )
   endif


;  time is forced to HH.HHH, a double
   timef=strtrim(time,2)   
   if strpos(timef,'.') eq -1 then begin
       if strpos(timef,':') eq -1 then begin  
           case strlen(timef) of
               1: timef= '0'+timef+'0000' ; H
               2: timef= timef+'0000' ; HH
               3: timef= '0'+timef+'00' ; HMM
               4: timef= timef+'00' ; HHMM
               5: timef= '0'+timef ; HMMSS
               6: timef= timef  ; HHMMSS
               else: time=complex(-1) ; flag an error
           endcase
       endif else begin
           case strlen(timef) of
               8: timef= strmid(timef,0,2)+strmid(timef,3,2)+strmid(timef,6,2) 
                                ; HH:MM:SS
               5: timef= strmid(timef,0,2)+strmid(timef,3,2)+'00' ; HH:MM
               else: time=complex(-1) ; flag an error
           endcase
       endelse
   endif

   type= (size(time))(1)
   if (type eq 1 or type eq 2 or type eq 3 or type eq 7) then begin
       time= double( strmid(timef,0,2) ) + $
         double( strmid(timef,2,2) ) / 60. + $
         double( strmid(timef,4,2) ) / 3600.
   endif else if (type eq 4) or (type eq 5)  then begin
       time=double(time)
   endif else begin
       print, 'Error in time format.  Use any of '
       print, 'HH:MM:SS, HHMMSS, HH:MM, HHMM, HH.HHH, HH'
       stop, ' '
   endelse

   month= fix(strmid(date,4,2))
   day= fix(strmid(date,6,2))
   year= fix(strmid(date,0,4))
   hour= fix(time)
   minute= fix( ( time - hour ) * 60 )
   second= fix( ( time - hour - minute/60. ) * 3600 )

   doy= julday( month, day, year ) - julday( 1, 1, year ) + 1
   doy96= julday( month, day, year ) - julday( 1, 1, 1996 ) + 1

   return
end
