pro test_it, zlog=zlog
   data= randomn(s,1000)
   erase
   if keyword_set(zlog) then begin
       e= { zlog:1 } 
       data= 10^data
   endif else begin
       e= { zlog:0 } 
   endelse

   for i=-1,-4,-1 do begin       
       if keyword_set(zlog) then begin
           e= { zlog:1 } 
       endif else begin
           e= { zlog:0 } 
       endelse

       print, 2.^(i+1)*0.8, 2.^(i)*0.8+2.^(i+1)*0.8
       !p.position= [ 0.2, 2.^(i)*0.95 +0.03, $
                      0.9, 2.^(i+1)*0.95 ]
       e= hydra_ztick_parm( data, _extra=e )
       help, /str, e
       plot, data, /noerase, _extra=e       
   endfor
end

function hydra_ztick_parm, zdata, panel=panel_in, $
                           zrange=zrange, $
                           zlog=zlog, $
                           zticks=zticks, $
                           fill=fill, $
                           options=options, $ ; see hydra_zlim_widget.pro
                           _extra=e

;  sets plot parameter keywords for the yaxis so that
;  things look nice.  The keywords are returned in a
;  structure that should be passed into plot via the
;  _extra convention.
;  The following keywords will be specified:
;     zlog, zrange, zticks
;  These may be specified:
;     ztickname
;
;  zlog logic:
;     Whether to use zlog or not may be specified in two places:
;     On the panel, or in the code (passed in to here via keyword).
;     The logic is:
;        code_specifies   manual_button_out -->  code specifies
;        code_specifies   manual_button_in  -->  panel specifies
;        code doesn't specify ---------------->  panel specifies

   common zscale, zscl
   if n_elements( zscl ) eq 0 then zscl=intarr(1,4)
   if n_elements( panel_in ) eq 0 then panel=0 else panel=panel_in(0)
   if n_elements( options ) eq 0 then zlim_options=0 else zlim_options=options

   center_zero = ( 1 and zlim_options ) eq 1
   include_zero = ( 2 and zlim_options ) eq 2
   multicycle_log_only = ( 4 and zlim_options ) eq 4
   smart= ( 8 and zlim_options ) eq 8 
   
; --- zlog logic ----------------
   manual= zscl(panel,0) eq 1
   zlog_panel= zscl(panel,3)
   if n_elements(zlog) eq 0 then begin
       zlog= zlog_panel
   endif else begin
       if manual then zlog= zlog_panel
   endelse
   zscl(panel,3)=zlog

   z_kw= { zlog:zlog }

; --- zrange logic --------------
   zrange_panel= zscl(panel,[1,2])
   if manual then begin
       zrange= zrange_panel
   endif else begin
       if n_elements( zrange ) eq 0 then begin
           if n_elements(fill) eq 0 then r= lindgen(n_elements(zdata)) else $
             r= where( zdata ne fill )

           if r(0) eq -1 then begin ; clumbsy code, sorry
               zdata_test= zdata
           endif else begin
               zdata_test= zdata(r)
               if zlog then begin
                   r= where( zdata_test gt 0. )
               endif else begin
                   r= lindgen( n_elements( zdata_test ) ) 
               endelse
           endelse

           if r(0) ne -1 then begin
               zdata_test= zdata_test(r)
               if smart then begin
;                  require 11 adjacent measurements to stat. agree
                   a= smooth(zdata_test,11) ; "average"
                   v= smooth((zdata_test-a)^2,11) ; "variance"
                   r= where( (zdata_test-a)^2 lt v*3^2 ) ; lt 5 sd's away
                   zdata_test= zdata_test(r)
               endif
               zmin= min( zdata_test, max=ymax ) 
               zrange= [zmin,ymax]
               if zlog then zrange= $
                 double(10)^[floor(alog10(zrange(0))), ceil(alog10(zrange(1)))]
           endif else begin
               if zlog then zrange=[1,10] else zrange=[0,1]
           endelse
       endif
       zscl(panel,1:2)=zrange
   endelse

   if not zlog then begin
       if center_zero then begin 
           ma= max(abs(zrange))
           zrange=[-ma,ma]
       endif
       if include_zero then begin
           zrange= [ zrange(0)<0., zrange(1)>0. ]
       endif
   endif   
   
   z_kw= create_struct( z_kw, { zrange:zrange } )


; --- zticks logic --------------
;  number of ticks depends on panel height.  Measure the panel height
;  by testing !p.position, convert to charsize heights, then decide
;  based on that.
   if n_elements( zticks ) eq 0 then begin
       nheight= !p.position(3)-!p.position(1) ; height in normal coord
       if !p.charsize eq 0 then charsize=1 else charsize=!p.charsize
       cheight= nheight * !d.x_size / ( !d.x_ch_size * charsize )
       if cheight lt 12 then zticks=fix(cheight/1.5+0.5) else zticks=0
;       zticks=0
   endif

; --- ztickv --------------------
; wow--this is getting complex, huh?  A new problem arises when we
; specify zticks--IDL places them without regard to the value of the
; tick, so unless zrange is carefully picked, then non-integral tickv's
; are used.  We need to specify tickv as well.
   if zlog then zr= alog10( zrange ) else zr=zrange
   if zticks gt 0 then begin
       zticks_max= zticks 
       mant= double([ 1,2,5,10,20,50,100,200,500 ]) ;redundancy intentional
       minor=       [ 10,4,5,10,4,5,10,4,5,10,4,5 ]
       exp=1 
       pick=-1
       repeat begin
           units= mant * double(10)^exp
           r= where( (zr(1)-zr(0)) / units lt zticks_max, count )
           if count eq 0 then begin
               exp= exp+1
               if exp eq -1 and zlog then pick=0
           endif else if count eq n_elements( mant ) then begin
               exp=exp-1 
           endif else begin
               pick= r(0)
           endelse
       endrep until pick gt -1
       units= units(pick)
       zminor= minor(pick)
       ztick0= units*ceil(zr(0)/units)
       zticks= fix((zr(1)-zr(0)) / units)
       if zticks le 1 then begin ; only gonna print two ticks, make them nice
           if not zlog then begin
               exp= double(10)^floor(alog10(max(abs(zr))))
               zr= exp*[floor(zr(0)/exp),ceil(zr(1)/exp)]
               z_kw.zrange= zr
               zminor= (zr(1)-zr(0))/exp
           endif
           ztickv= zr
           zticks= 1
           if zlog then begin
               ztickv(0)= ceil(ztickv(0))
               ztickv(1)= floor(ztickv(1))
           endif
       endif else begin           
           ztickv= ztick0 + dindgen(zticks+1) * units
       endelse
       if zlog then begin
           if units gt 1 then begin
               zminor=units 
               ztickv=10^ztickv
           endif else begin
               zticks=0         ; don't touch a thing!
               zminor=0
               ztickv=0
           endelse
       endif
       z_kw= create_struct( z_kw, $
                            { zticks:zticks, ztickv:ztickv, zminor:zminor } )
   endif else begin
       z_kw= create_struct( z_kw, { zticks:zticks } )
   endelse

; --- pass other keywords ------
   if n_elements( e ) gt 0 then z_kw= create_struct( z_kw, e )

   return, z_kw
end
