pro spectra_sort, avg0, modes, mode_energy, avg1, energy
;  sorts a matrix avg0 where each spectrum has its own 
;  mode-dependent energies into a matrix with energies that
;  are independant of time.

;  find the unique energy levels that are visible in this period.
   mode_index= modes( uniq( modes ) )-1
   if (n_elements(mode_index) gt 1) then $
    mode_index = mode_index(uniq(mode_index,sort(mode_index)))
   mode_energy_part= mode_energy(*,mode_index)
   r = where(mode_energy_part NE 0.0)
   energy= mode_energy_part( where( mode_energy_part ne 0.0 ) )
   u = uniq( energy, sort(energy) )
   energy= energy(u)

;  form a map from energy index to unique energy level number.
   nen= ( size( mode_energy ) )(1)
   block_energy_index = make_array( size=size(mode_energy), /int)
   for m=0, n_elements(mode_index)-1 do begin
       mb = mode_index(m)
       if mb ge 0 then begin
           for j=0, nen-1 do begin
               block_energy_index(j,mb) = where(energy EQ mode_energy(j,mb))
           endfor
       endif
   endfor
       
;  form the spectrogram
   neng= n_elements( energy )
   
   avg1 = make_array( neng, n_elements(avg0(0,*)), /float, value=1.e-20 )
   if (n_elements(mode_index) eq 1) then begin ; no mode changes, simpler case
       mb = mode_index(0)
       r = where(block_energy_index(*,mb) ge 0)
       avg1 = avg0(r,*)
   endif else begin
       for im=0,n_elements(mode_index)-1 do begin
           mb = mode_index(im)
           if mb gt 0 then begin
               r = where(block_energy_index(*,mb) ge 0)
               for en=0, n_elements(r)-1 do begin
                   ir = where(modes EQ mb+1)
                   avg1(block_energy_index(r(en),mb),ir) = $
                     avg0(r(en),ir)
               endfor
           endif
       endfor
   endelse
   
   return
end

