pro test_get_plot_coordinates
  set_plot, 'ps' 
  device, /color, bits=8
  hydra_setcolors, cs
  !p.multi=[0,2,2]
  resolutions=[50,75,150,300]
  for i=0,3 do begin
      qq= hyd_get_plot_coordinates(ps_dpi=resolutions(i)) 
      tv= bytarr(qq.x_size_pixel,qq.y_size_pixel) 
      tv(*)= cs.black
      r= indgen(n_elements(tv(*,0)/2)) * 2 
      tv(r,*)= cs.white  
      tv, tv, qq.x_pos_normal, qq.y_pos_normal, $
        xsize=qq.x_size_normal, ysize=qq.y_size_normal, /normal
      plot, [0,1], [0,1], /nodata, /noerase
      !p.multi(0)=!p.multi(0)-1
      if !p.multi(0) lt 0 then !p.multi(0)= !p.multi(1)*!p.multi(2) - 1
  endfor
  device, /close
end
