pro tri_reject, T, test
;+
; NAME: tri_reject
;
; PURPOSE: reject triangles with vertices containing a particular condition
;
; CATEGORY: utility
;
; CALLING SEQUENCE: tri_reject, <triangles>, <test>
;
; INPUTS: 
;   triangles,  from trigrid, etc; in the form lonarr(3,n)
;   test        boolean intarr(n); 1=reject, 0=keep
;
; OUTPUTS:
;   triangles is modified.  If all triangles are rejected by the
;      condition, then the zeroth triangle is returned.
;
; RESTRICTIONS/NOTES:
;   this routine is questionably useful, and may not be maintained. jbf
;
; EXAMPLE:
;   tri_reject, T, y lt 10.
;
; MODIFICATION HISTORY:
;   written, jbf, Dec 6, 1998.
;-
   keep= lonarr(n_elements(T(0,*)))+1
   r= where( test )
   if r(0) ne -1 then keep(r/3)=0   
   rkeep= where(keep)
   if rkeep(0) ne -1 then T=T(*,rkeep) else begin
       message, 'test rejects all triangles, keeping 0th triangle', /cont
       T=T(*,0)
   endelse
end
