function unwrap_phi, phi0, degrees=degrees
;
;   Unwrap Phi angle.
;
;
pi2=2*!pi
phi=phi0
if keyword_set(degrees) then phi=phi0*!dtor
rnz=where(phi ne 0)
phi_nz=phi(rnz)
n=n_elements(phi_nz)
dphi=phi_nz(1:n-1)-phi_nz(0:n-2)
r=where(abs(dphi) gt 5, nr)
if nr gt 0 then begin
    nwrap=0
    for i=0,nr-2 do begin
        if dphi(r(i)) gt 5 then nwrap=nwrap-1 else nwrap=nwrap+1
        phi_nz(r(i)+1:r(i+1))=phi_nz(r(i)+1:r(i+1))+nwrap*pi2
    endfor
    i=nr-1
    if dphi(r(i)) gt 5 then nwrap=nwrap-1 else nwrap=nwrap+1
    phi_nz(r(i)+1:n-1)=phi_nz(r(i)+1:n-1)+nwrap*pi2
endif

phi(rnz)=phi_nz
if keyword_set(degrees) then phi=phi/!dtor

return, phi
end
