pro xyouts_anti_alias, x_in, y_in, string, _extra=e, $
                       normal=normal, $
                       device=device, $
                       charsize=charsize, $
                       ctable=ctable

  zbuf=1

  x= x_in
  y= y_in
  
  if n_elements( charsize ) eq 0 then charsize=!p.charsize
  if charsize eq 0 then charsize=1

  if !d.name eq 'PS' then begin
      xyouts, x, y, string, charsize=charsize, $
        normal=normal, device=device, _extra=e
      return
  endif

  ncol= ctable(1)-ctable(0)+1
  base_col= ctable(0)

  if keyword_set( normal ) then begin
      r= convert_coord( x, y, /normal, /to_device )
      x= r(0)
      y= r(1)
      device=1
  endif

  if not keyword_set( device ) then begin
      r= convert_coord( x, y, /data, /to_device )
      x= r(0)
      y= r(1)
  endif
      
  x_size= !d.x_size
  y_size= !d.y_size

  x_ch_size= !d.x_ch_size
  y_ch_size= !d.x_ch_size

  old_image= tvrd()
  window_num= !d.window

  set_plot_old= !d.name
  
;  calculate buffer size required.
  if zbuf then begin
      set_plot, 'z'
      device, set_resolution=[x_size,y_size]
      device, set_character_size=[x_ch_size,y_ch_size]
  endif

  erase, 0
  xyouts, /device, x, y, string, _extra=e, color=1, $
    charsize=charsize
  d= tvrd()

  projx= total(d,2)
  r= where( projx gt 0, count )
  if count eq 0 then return     ; nothing to do
  x_size_buf= r(count-1)-r(0)+4
  x_orig_buf= r(0) -2
  projy= total(d,1)
  r= where( projy gt 0, count )
  if count eq 0 then return     ; nothing to do
  y_size_buf= r(count-1)-r(0)+4
  y_orig_buf= r(0) -2
;  end, calculate buffer size required
  
  if zbuf then begin
      set_plot, 'Z'
      device, set_resolution=[x_size_buf,y_size_buf]
      device, set_character_size=[x_ch_size,y_ch_size]
  endif else begin
      set_plot, 'x'
      window, xsize= x_size_buf, ysize= y_size_buf
  endelse

  x= x - x_orig_buf
  y= y - y_orig_buf

;  begin averaging
  n= 0
  
  value= tvrd()                 ; color accumulators
  value(*)=0
  
  for i=-1.,1 do begin
      for j=-1.,1 do begin
          erase, 0
          xyouts, /device, x+i/3., y+j/3., string, _extra=e, color=1, $
            charsize=charsize
          d= tvrd()
          n= n+1
          value= value + d      ; inefficient, included for clarity
      endfor
  endfor

  old_image_sub= old_image( x_orig_buf:(x_orig_buf+x_size_buf-1), $
                            y_orig_buf:(y_orig_buf+y_size_buf-1) )
  

  value= value / float(n) ; range is 0. to 1.

;  gamma-adjust value
  in=    [ 0, 1, 2, 3, 4, 5, 6, 7,      8,  9, 10 ] / 10.
  out=   [ 0, 2, 4, 6, 7, 8, 9, 9.5, 9.75, 10, 10 ] / 10.
  value= interpol( out, in, value )

  r= where( value gt 0. )
  if r(0) ne -1 then begin
      old_image_sub(r)= bytscl(value(r),top=ncol-1)+base_col
  endif

  set_plot, set_plot_old
  if !d.name eq 'Z' then begin
      device, set_resolution=[x_size,y_size]
      device, set_character_size=[x_ch_size,y_ch_size]
  endif else begin
;      window, xsize=x_size, ysize=y_size
;wset, window_num
  endelse
  
  tv, old_image
  tv, old_image_sub, x_orig_buf, y_orig_buf, /dev
end
