FUNCTION tick_hr, i, j, t
;+
; NAME:tick_hr
; PURPOSE: print hour tick labels
; CATEGORY: utility, tick label
; CALLING SEQUENCE: plot, ..., tickformat='tick_hr'
; INPUTS: axis must be in hours.
; EXAMPLE: plot, indgen(7)+2, randomn(s,7), tickformat='tick_hr'
; MODIFICATION HISTORY: 
;-

   th = long(t)
   tm = long((t - th)*60.0+0.5)

   time = string(th, format='(i2.2)')+':'+string(tm, format='(i2.2)')
   
   return, time
END
