pro update_path, new_dir, add=add, delete=delete
;+
;  Add/Delete a directory to/from the !path variable
;
;  Add is the default.
;
;  Usage: update_path, <path>, [/add], [/delete]
;-

path_sep=':'
if !version.os_family eq 'Windows' then path_sep=';'

if n_params() eq 0 then begin
    print, transpose(str_sep(!path, path_sep))
    return
endif

if not keyword_set(delete) then add=1

if rstrpos(new_dir,'/') eq strlen(new_dir)-1 then $
  new_dir=strmid(new_dir,0,strlen(new_dir)-1)

path=str_sep(!path, path_sep)
r=where(path eq new_dir,nr)
if nr eq 0 and keyword_set(add) then begin
    !path=!path+path_sep+new_dir
endif else if keyword_set(delete) then begin
    path(r)=''
    r=where(path ne '', nr)
    !path=path(r(0))
    for ir=1, nr-1 do !path=!path+path_sep+path(r(ir))
endif
end
