pro write_bracket_file, date, iblock, isub, bracket, model=model
;
;  Write the Bracket file for the given date
;
;
  if keyword_set(model) then begin
      common model_bracket, mb
      if not keyword_set(mb) then begin
          mb= bracket
      endif
      return
  endif

  bracket_dir='/opt/hydra/2sweep_uperp/bracket/'
  bracket_file=bracket_dir+strtrim(date,2)+'_brackets.idlsav'
  lockfile= bracket_file+'.lock'
  
  status=idl_lockfile(lockfile, wait=30)
  if status ne 0 then begin
      message, 'ERROR opening bracket: lockfile open failed.'
  endif else begin

      restore, bracket_file

      r=where(brackets.iblock eq iblock and brackets.isub eq isub,nr)
      if nr ne 1 then begin
          message, 'block/sub not found in bracket.', /cont
          bracket1= brackets[0]
          struct_assign, bracket, bracket1
          brackets= [ brackets, bracket1 ]          
          r=where(brackets.iblock eq iblock and brackets.isub eq isub,nr)
      endif else begin
          if total(abs(bracket.bracket-brackets(r(0)).bracket)) eq 0 then begin
              status=idl_lockfile(lockfile, /rm)
              if status ne 0 then begin
                  message, 'ERROR opening bracket: lockfile rm failed.'
              endif
              return
          endif
      endelse
      print, 'Writing new brackets for ', date, iblock, isub

      names=tag_names(bracket)
      for i=0,n_elements(names)-1 do begin
          res=execute('brackets(r(0)).'+names(i)+'=bracket.'+names(i))
          if res ne 1 then message, 'ERROR updating brackets.'
      endfor

      save, file=bracket_file, brackets
      spawn, 'chmod 664 '+bracket_file

      status=idl_lockfile(lockfile, /rm)
      if status ne 0 then begin
          message, 'ERROR opening bracket: lockfile rm failed.', /cont
      endif
  endelse

  return
end
