PRO moments_status_stat, date, indir=indir

; This routine calculates the percentage of different status of
; moments calculation both for electron and ion statistically.
; Note: The detail of each moments status decimal digit is documented
; in '/home/xxc/rc_hydra/rc_release/ddeis_moments_integrator_v02.F'

; OUTPUT PHRASE:
;   SUCCESSFUL:  have values of 14 moments
;     1. SUCCESSFUL-PATCH: normal case, all b !=0
;   UNSUCCESSUL: no values of 14 moments. It has three case:
;     1. NO-POTENTIAL:
;     2. ZERO-COUNT: all zero counts for one or both box(s).
;     3. INVALID-TEMP-TENSOR: trace of temperature tensor <= 0
;     
; USAGE:
;   moments_status_stat,960529
;
; ONE MANDATORY ARGUMENT(DATE): YYMMDD or YYYYMMDD
;
; ONE OPTIONAL KEYWORD:
;  indir='cdf_directory_path'    INPUT
;--------------------------------------------------------------
   IF (n_params() EQ 0) THEN BEGIN
      print, ' '
      print, '---------------------------------------------
      print, 'USAGE:'
      print, 'moments_status_stat,960529'
      print, ' '
      print, 'MANDATORY ARGUMENT:  YYMMDD or YYYYMMDD'
      print, 'OPTIONAL KEYWORD:'
      print, 'indir="cdf_directory_path"'
      print, '          NOTE: Default path is /opt/hydra/moment_data*/full/'
      print, ' '
      print, 'OUTPUT PHRASE:'
      print, '  SUCCESSFUL:  have values of 14 moments'
      print, '    1. SUCCESSFUL-PATCH: normal case, all b !=0'
      print, '  UNSUCCESSUL: no values of 14 moments. It has three case:'
      print, '    1. NO-POTENTIAL: no potetial available.'
      print, '    2. ZERO-COUNT: all zero counts for one or both box(s).'
      print, '    3. INVALID-TEMP-TENSOR: trace of temperature tensor <= 0.'
      return
   ENDIF

   species = ["ELE", "ION"]
   FOR ispecies=0, 1 DO BEGIN 
      IF (keyword_set(indir)) THEN BEGIN
         IF (ispecies EQ 1) THEN begin
            f = hydra_findfile( date, /moments_ion, path=indir,$
                                version=version)
         ENDIF ELSE BEGIN
            f = hydra_findfile( date, /moments_all, path=indir,$
                                version=version)
         ENDELSE
      ENDIF ELSE BEGIN
         IF (ispecies EQ 1) THEN BEGIN 
            f = hydra_findfile( date, /moments_ion, version=version)
         ENDIF ELSE BEGIN
            f = hydra_findfile( date, /moments_all, version=version)
         ENDELSE
      ENDELSE

      IF(f NE '') THEN cdf = cdf_open(f) ELSE $
       message, "The moments file does not exist for this day."

      cdf_control, cdf, variable='time', get_var_info=r
      IF r.maxrec EQ -1 THEN BEGIN
         print, 'No data found in CDF'
         return
      ENDIF
      cdf_varget, cdf, 'time', time, rec_count=r.maxrec+1
      rec_count= n_elements(time)
      cdf_varget, cdf, 'status',status, rec_count=rec_count
   
      isthere = cdf_varexist(cdf,'failed_time')
      IF (isthere) THEN BEGIN
         cdf_control, cdf, variable='failed_time', get_var_info=x
         cdf_varget, cdf, 'failed_time', failed_time, rec_count=x.maxrec+1
         failed_rec_count= n_elements(failed_time)
         cdf_varget, cdf, 'failed_status',failed_status, $
          rec_count=failed_rec_count
      ENDIF ELSE BEGIN 
         failed_rec_count = -1
      ENDELSE 

      cdf_close, cdf

      id = where(((status/10000) MOD 10) EQ 1 OR $
                 ((status/10000) MOD 10) EQ 2 )
      IF(id(0) NE -1) THEN success_patch_count = n_elements(id) $
      ELSE success_patch_count = 0 

      IF (failed_rec_count EQ -1) THEN BEGIN 
         print, species(ispecies)+" for day:", date
         print, "moments CDF VERSION:",  version
         print, "The moments CDF for this version did not document records for failed blocks."
         print, "Number of SUCCESSFUL moments blocks:", rec_count,"," ,$
          float(rec_count)/rec_count*100,"%."
         print, "Number of SUCCESSFUL-PATCH blocks:", success_patch_count, ",",$
          float(success_patch_count)/rec_count*100,"%."
      ENDIF ELSE BEGIN 
         IF (failed_status(0) EQ -2147483648) THEN BEGIN 
            no_pot_count = 0
            zero_count = 0
            invalid_temp_count = 0
            failed_rec_count = 0
         ENDIF ELSE BEGIN 
            id = where(failed_status/10000000 EQ -2)
            IF(id(0) NE -1) THEN no_pot_count = n_elements(id) $
            ELSE no_pot_count = 0
            
            id = where(failed_status/10000000 EQ -1)
            IF(id(0) NE -1) THEN zero_count = n_elements(id) $
            ELSE zero_count = 0 
         
            id = where(((failed_status/1000000) MOD 10) EQ 2)
            IF(id(0) NE -1) THEN invalid_temp_count = n_elements(id) $
            ELSE invalid_temp_count = 0 
         ENDELSE  
         total_rec_count = rec_count+failed_rec_count

         print, species(ispecies)+" for day:", date
         print, "moments CDF VERSION:",  version
         print, "TOTAL number of blocks:", total_rec_count 
         print, "Number of SUCCESSFUL moments blocks:", rec_count,"," ,$
          float(rec_count)/total_rec_count*100,"%."
         print, "Number of UNCCESEEFUL moments blocks:", failed_rec_count, ",",$
          float(failed_rec_count)/total_rec_count*100,"%."
         print, "Number of NO-POTENTIAL blocks:", no_pot_count, ",",$
          float(no_pot_count)/total_rec_count*100,"%."
         print, "Number of ZERO-COUNT blocks:", zero_count, ",",$
          float(zero_count)/total_rec_count*100,"%."
         print, "Number of INVALID-TEMP-TENSOR blocks:", invalid_temp_count, ",",$
          float(invalid_temp_count)/total_rec_count*100,"%."
         print, "Number of SUCCESSFUL-PATCH blocks:", success_patch_count, ",",$
          float(success_patch_count)/total_rec_count*100,"%."
      
      ENDELSE 

   ENDFOR 
   
END 


