pro draw_hydra_kp, panelVector, currPlotInfo, orbitNo, $
                     get_data_call, slice_type, IsRead

   common extra, extra_PlotInfo
   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg
   common hydra_kp_data, $
    kp_species, $
    kp_header, $
    kp_lr_ele_data, $
    kp_lr_ele_attr, $
    kp_lr_ion_data, $
    kp_lr_ion_attr, $
    kp_hr_ele_data, $
    kp_hr_ele_attr

COMMON kp_loaded, lreleloaded, lrionloaded, hreleloaded

   kp_species = currPlotInfo.typeVector(0)

   if currPlotInfo.typeVector(1) ge 3 and $
     currPlotInfo.typeVector(1) le 7 then begin
       kp_species= 2            ; HR kp.
   endif

   if currPlotInfo.typeVector(1) eq 8 then begin
;     see special code below
   endif

   if n_elements( kp_header ) eq 0 then begin
      mh1={ hydra_kp_dum_header, $
           start_time:long(0), $
           end_time:long(0), $
           data_version:float(0), $
           reload_flag:fix(0) $
         }
      kp_header = replicate(mh1,3)
   endif

   get_data_call="r_hydra_kp"

   YesLoad= $
    (NOT keyword_set(lreleloaded) AND kp_species EQ 0)  OR  $
    (NOT keyword_set(lrionloaded) AND kp_species EQ 1)  OR  $
    (NOT keyword_set(hreleloaded) AND kp_species EQ 2)  OR  $
     kp_header(kp_species).start_time gt xut1    or  $
     kp_header(kp_species).end_time lt xut2      or  $
     kp_header(kp_species).reload_flag      ; set with panel

   if hydra_new_papco() then begin
       n=(papco_slice_value('USER Hydra fV Slice')>0)
       slice_type= 1+16
   endif else begin
       slice_type= 1
   endelse

   if currPlotInfo.typeVector(1) ge 8 and $
     currPlotInfo.typeVector(1) le 9 then begin
       kp_species= 0            ; load ele
       kp_header(kp_species).start_time=xut1
       kp_header(kp_species).end_time=xut2
       kp_header(kp_species).reload_flag=1
       r_hydra_kp
       lreleloaded=1

       kp_species= 1            ; load ion
       kp_header(kp_species).start_time=xut1
       kp_header(kp_species).end_time=xut2
       kp_header(kp_species).reload_flag=1
       r_hydra_kp       
       lrionloaded=1

       YesLoad=0
   endif
   

   IF YesLoad THEN BEGIN
       kp_header(kp_species).start_time=xut1
       kp_header(kp_species).end_time=xut2
       kp_header(kp_species).reload_flag=1
       r_hydra_kp
       IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                 panelVector, orbitNr, $
                                 currPlotInfo.typeVector, $
                                 currPlotInfo.channel) $
         THEN BEGIN
           kp_header(kp_species).reload_flag=0
           IsRead=1
           p_hydra_kp, panelVector, currPlotInfo.typeVector, $
             _EXTRA=extra_PlotInfo

           check = PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                          panelVector, orbitNr, $
                                          currPlotInfo.typeVector, $
                                          currPlotInfo.channel)
           
; Who have we loaded so far?
           IF kp_species EQ 0 THEN lreleloaded =  1
           IF kp_species EQ 1 THEN lrionloaded =  1
           IF kp_species EQ 2 THEN hreleloaded =  1

       ENDIF
   ENDIF ELSE BEGIN
       p_hydra_kp, panelVector, currPlotInfo.typeVector, $
         _EXTRA=extra_PlotInfo
       check = PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                      panelVector, orbitNr, $
                                      currPlotInfo.typeVector, $
                                      currPlotInfo.channel)
   ENDELSE

END

