pro draw_hydra_moments, panelVector, currPlotInfo, orbitNo, $
                        get_data_call, slice_type, IsRead
   
   common extra, extra_PlotInfo
   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg
   common hydra_moments_data, $
    moments_species, $
    moments_header, $
    moments_ele_data, $
    moments_ion_data
   
   COMMON moments_loaded, eleloaded, ionloaded
   
   moments_species = currPlotInfo.typeVector(0)
   
   get_data_call=""
   
   if hydra_new_papco() then begin
       n=(papco_slice_value('USER Hydra fV Slice')>0)
       slice_type= 1+2+16
   endif else begin
       slice_type= 1+2
   endelse
   
   common papco_color_names
   if ( currPlotInfo.ioptions(15) and 1 ) eq 1 then begin ; color enhancements
       hp_kw= { reference:currPlotInfo.options(15) }
       if (currPlotInfo.ioptions(15) and 4)/4 then $
         hp_kw= create_struct( hp_kw, { poly_above_ref:red} )
       if (currPlotInfo.ioptions(15) and 2)/2 then $
         hp_kw= create_struct( hp_kw, { poly_below_ref:blue} )
       extra_PlotInfo= create_struct( hp_kw, extra_PlotInfo )
   endif
      
   IF n_elements( moments_header ) EQ 0 THEN YesLoad=1 ELSE BEGIN 
      YesLoad= $
       (NOT keyword_set(eleloaded) AND moments_species EQ 0)  OR  $
       (NOT keyword_set(ionloaded) AND moments_species EQ 1)  OR  $
       (moments_header(moments_species).start_time gt xut1)   OR  $
       (moments_header(moments_species).end_time lt xut2 )    OR  $
       (moments_header(moments_species).reload_flag ) ; set with panel 
      YesLoad= YesLoad or ( currPlotInfo.filename ne '' )
   ENDELSE

   IF YesLoad THEN BEGIN
      r_hydra_moments, file=currPlotInfo.filename
      IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                panelVector, orbitNr, $
                                currPlotInfo.typeVector, $
                                currPlotInfo.channel) $
       THEN BEGIN
         moments_header(moments_species).reload_flag=0
         IsRead=1
         p_hydra_moments, panelVector, currPlotInfo.typeVector, $
          _EXTRA=extra_PlotInfo
         
; Who have we loaded so far?
         IF moments_species EQ 0 THEN eleloaded =  1
         IF moments_species EQ 1 THEN ionloaded =  1
         
      ENDIF
   ENDIF ELSE BEGIN
      p_hydra_moments, panelVector, currPlotInfo.typeVector, $
       _EXTRA=extra_PlotInfo
   ENDELSE
   
END

