pro draw_hydra_ppa, panelVector, currPlotInfo, orbitNo, $
                        get_data_call, slice_type, IsRead
   
   common extra, extra_PlotInfo
   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg

   common hydra_ppa_data, $
    ppa_header, $
    ppa_l1_data, $
    ppa_l1_support, $
    ppa_spec_data, $
    ppa_aligned_data, $
    ppa_opposed_data, $
    ppa_perp_data, $
    ppa_skew_data

   COMMON hydra_previous_plottimes, xut1_old, xut2_old
   
   get_data_call=""
   
   if hydra_new_papco() then begin
;       n=(papco_slice_value('USER Hydra fV Slice')>0)
       n=0
       n=n+(papco_slice_value('USER Hydra PPA Slice')>0)
       slice_type= 1+16+2+n
   endif else begin
       slice_type= 1
   endelse
   
   IF n_elements( ppa_header ) EQ 0 THEN BEGIN

      YesLoad=1 
      xut1_old = xut1
      xut2_old = xut2

   ENDIF ELSE BEGIN 

      YesLoad= $
       (ppa_header.start_time gt xut1)   OR  $
       (ppa_header.end_time lt xut2 )    OR  $
       (ppa_header.reload_flag ) ; set with panel


      YesCalc = (xut1_old NE xut1) OR (xut2_old NE xut2)
      IF YesCalc THEN ppa_header.recalc_flag = YesCalc 

; NOTE: recalc_flag=intarr(ncalc), all initialized to 1 in
; r_hydra_ppa, set to 0 individually iff calculated in p_hydra_ppa, 
; all set to 1 here if YesCalc (for safety purposes), otherwise untouched
      
   ENDELSE
   
   IF YesLoad THEN BEGIN
      r_hydra_ppa
      IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                panelVector, orbitNr, $
                                currPlotInfo.typeVector, $
                                currPlotInfo.channel) $
       THEN BEGIN
         ppa_header.reload_flag=0
         IsRead=1
         p_hydra_ppa, panelVector, currPlotInfo.typeVector, $
          _EXTRA=extra_PlotInfo
         xut1_old = xut1 & xut2_old = xut2
         
      ENDIF
   ENDIF ELSE BEGIN
      p_hydra_ppa, panelVector, currPlotInfo.typeVector, $
       _EXTRA=extra_PlotInfo
         xut1_old = xut1 & xut2_old = xut2
   ENDELSE
   
END

