pro fft_event, event
COMMON share, comprs_tlb

widget_control, comprs_tlb, get_uvalue=state
;  widget_control, event.top, get_uvalue=state
widget_control, event.id,  get_uvalue=uval


print,'EVENTS=',event.top,event.id

case uval of 

  'compressible': begin
    state.var.operation='compress'
    redraw=1
  end

  'polytropic': begin

    if not widget_info( state.id.poly_tlb, /valid_id) $
      then begin

; Top level base
      state.id.poly_tlb= widget_base( xoffset=300, yoffset=530, $
                                      title='Polytrope', /col )

; Plot area
      poly_plot_area = $
                      widget_draw(state.id.poly_tlb, xsize=400, ysize=400)
      widget_control, poly_plot_area, /realize
      widget_control, poly_plot_area, get_value=poly_plot_area
      state.id.poly_plot_area = poly_plot_area

; Button area
      poly_but_area1= widget_base( state.id.poly_tlb, /row )
      state.id.poly_but_area1=poly_but_area1
      bu= widget_button( poly_but_area1, value='Print', $
                         uvalue='print_poly')
      state.id.poly_button_p=bu

      bu= widget_button( poly_but_area1, value='Close', $
                         uvalue='close_poly')
      state.id.poly_button_c=bu
      xmanager, 'fft', state.id.poly_tlb
    endif

    print,''
    print,'state.id.poly_tlb      =', strtrim(state.id.poly_tlb,2)
    print,'state.id.poly_plot_area= ',strtrim(state.id.poly_plot_area,2)

    state.var.operation='poly'
    redraw=1
  end

  'operation_X': begin
    state.var.operation='noop'
    redraw=1
  end



  'Print': begin
    state.var.operation = 'compress'
    fft, /print
  end

  'Close': begin
    if widget_info( state.id.poly_tlb, /valid_id ) then begin
      widget_control, state.id.poly_tlb, /destroy
    end
    widget_control, event.top, /destroy
    return
  end

  'Help': begin
    xdisplayfile, $
                 '/opt/hydra/papco/polar_hydra/papco_interface/fft.help', $
                 title='papco Online-Help', group=event.top         
  end

  'Draw': begin
    state.var.operation = 'compress'
    redraw=1
  end


; desensitize polytrope Print button if new date/time data entered.
  'start_date_uval': begin
    if widget_info(state.id.poly_tlb, /valid_id) then begin
      widget_control, state.id.poly_button_p, sensitive=0
    end

    st_time = state.var.start_doy96 - fix(state.var.start_doy96)
    state.var.start_doy96 = gen_time(date=event.value) + st_time
    state.var.operation = 'compress'
    redraw=1
  end

; desensitize polytrope Print button if new date/time data entered.
  'start_time_uval': begin
    if widget_info(state.id.poly_tlb, /valid_id) then begin
      widget_control, state.id.poly_button_p, sensitive=0
    end

    state.var.start_doy96 = fix(state.var.start_doy96) + $
      gen_time(time=event.value)
    state.var.operation = 'compress'
    redraw=1
  end


; desensitize polytrope Print button if new date/time data entered.
  'end_date_uval': begin
    if widget_info(state.id.poly_tlb, /valid_id) then begin
      widget_control, state.id.poly_button_p, sensitive=0
    end

    et_time = state.var.end_doy96 - fix(state.var.end_doy96)
    state.var.end_doy96 = gen_time(date=event.value) + et_time
    state.var.operation = 'compress'
    redraw=1
  end

; desensitize polytrope Print button if new date/time data entered.
  'end_time_uval': begin
    if widget_info(state.id.poly_tlb, /valid_id) then begin
      widget_control, state.id.poly_button_p, sensitive=0
    end

    state.var.end_doy96 = fix(state.var.end_doy96) + $
      gen_time(time=event.value)
    state.var.operation = 'compress'
    redraw=1
  end



; Polytrope Buttons
  'print_poly': begin
    state.var.operation='poly'
    widget_control, comprs_tlb , set_uvalue=state
    fft_draw, /print, debug=state.var.debug
    return
  end

  'close_poly': begin
    widget_control, event.top, /destroy
    return
  end

  else: begin
    message, 'uval not recognized: '+uval, /cont
  end
end      

widget_control, comprs_tlb, set_uvalue=state
;  widget_control, event.top, set_uvalue=state

if keyword_set( redraw ) then fft

return
end






pro fft_draw, print=print, exceptionString=exceptionString, debug=debug
COMMON share
widget_control, comprs_tlb, get_uvalue=state
st_time = state.var.start_doy96 - fix(state.var.start_doy96)
et_time = state.var.end_doy96   - fix(state.var.end_doy96)

if keyword_set(print) then begin
  set_plot, 'ps'
  filename=gen_time_string(fix(state.var.start_doy96)) + $
           state.var.operation + gen_time_string(st_time) + '-' + $
           gen_time_string(et_time) + '.ps'
  device, filename=filename, xsize=7.5, ysize=7,/inches, /color, /landscape
endif else if state.var.operation eq 'compress' then begin
  hyd_set_plot, 'x'             ; hyd_set_plot uses 'win' for windows and 'x' for unix
  wset, state.id.comprs_plot_area
  !p.multi = [0,1,1]

; desensitize polytrope Print button if new date/time data entered
  if widget_info( state.id.poly_tlb, /valid_id ) then begin 
    widget_control, state.id.poly_button_p, sensitive=0
  end

endif else if state.var.operation eq 'poly' then begin
  hyd_set_plot, 'x'             ; hyd_set_plot uses 'win' for windows and 'x' for unix
  wset, state.id.poly_plot_area
  !p.multi = [0,1,2]

; desensitize polytrope Print button if new date/time data entered
  if widget_info( state.id.poly_tlb, /valid_id ) then begin
    widget_control, state.id.poly_button_p, sensitive=1
  end
endif

!p.position=0
!p.noerase=0
!p.background = get_color_index('white')
!p.color      = get_color_index('black')
erase

sd_temp = gen_time_string( fix(state.var.start_doy96 ))
st_temp = gen_time_string( st_time )
ed_temp = gen_time_string( fix(state.var.end_doy96 ))
et_temp = gen_time_string( et_time )
widget_control, state.id.sd, set_value=sd_temp
widget_control, state.id.st, set_value=st_temp
widget_control, state.id.ed, set_value=ed_temp
widget_control, state.id.et, set_value=et_temp

err_hdl=''

if debug eq 0 then begin

  which, 'compress.pro'
  which, 'dd_findnorm_with_errors.pro'
  which, 'new_error_flags_jds.pro'
  which, 'new_gen_fit.pro'
  print, 'START =', gen_time_string(state.var.start_doy96)
  print, 'END   =', gen_time_string(state.var.end_doy96)
  print, ''

  case state.var.operation of
    'compress': begin
      compress, $
               state.var.start_doy96, $
               state.var.end_doy96, $
               err_hdl=err_hdl

;              print,'ERR_HDL=',err_hdl
      if err_hdl ne 'No errors' then begin
        xdisplayfile, $
                     '/opt/hydra/papco/polar_hydra/papco_interface/fft.err', $
                     text=err_hdl, $     
                     title='Application Exception',/modal
      end
    end

    'poly':     polytr,     state.var.start_doy96, state.var.end_doy96

    else: print, 'NO OPERATION PERFORMED'
  endcase
endif else begin
  case state.var.operation of
    'compress': plot, indgen(100)
    'poly':     plot,-indgen(100)
    else: print, 'NO OPERATION PERFORMED'
  endcase
endelse

print, 'Operation performed = ',state.var.operation
print, 'START =', gen_time_string(state.var.start_doy96)
print, 'END   =', gen_time_string(state.var.end_doy96)
print, ''

if keyword_set(print) then begin
  device, /close
  r= widget_message(['Send this file to the printer of your choice:',$
                     filename], /info )
  set_plot, 'x'
endif

state.var.operation='compress'
widget_control, comprs_tlb, set_uvalue=state
end









pro fft_build, a, b, debug=debug
COMMON share
; Define a structure for the state of the application
id=   { $
;            comprs_tlb:0L, $
       comprs_plot_area:0L, $
       sd:0L, $
       st:0L, $
       ed:0L, $
       et:0L, $
       poly_tlb:0L, $
       poly_plot_area:0L, $
       poly_but_area1:0L, $
       poly_button_p:0L, $
       poly_button_c:0L $
      }

var=  { $
       start_doy96:a, $
       end_doy96:b, $
       operation:'compress', $
       debug:debug $
      }

state={ $
       id:id, $
       var:var $
      }           

; Build the initial overall widget.
state.var.debug=debug

if debug eq 1 then begin
  device, get_screen_size=screen_size
  comprs_tlb = widget_base( $
                           xoffset=screen_size[0]*.63, $
                           yoffset=screen_size[1]*.41, $
                           title='hydra_fft', /col )
endif else begin
  comprs_tlb = widget_base( title='hydra_fft', /col )
endelse
print,'comprs_tlb =',strtrim(comprs_tlb,2)

; Build comprs plot area
plot_area = widget_draw( comprs_tlb, xsize=400, ysize=400)
widget_control, plot_area, /realize
widget_control, plot_area, get_value=comprs_plot_area
state.id.comprs_plot_area = comprs_plot_area
wset, comprs_plot_area
print,'state.id.comprs_plot_area= ',strtrim(comprs_plot_area,2)

; Build first row of buttons for comprs 
button_area1 = widget_base( comprs_tlb, /row )
bu= widget_button( button_area1, value='Compressible', uvalue='compressible' )
bu= widget_button( button_area1, value='Polytropic',   uvalue='polytropic' )
bu= widget_button( button_area1, value='Operation_X', uvalue='operation_X' )


; Build second row of buttons for comprs 
button_area2= widget_base( comprs_tlb, /row )
bu= widget_button( button_area2, value='Print',   uvalue='Print' )
bu= widget_button( button_area2, value='Close',   uvalue='Close' )
bu= widget_button( button_area2, value='Help',    uvalue='Help' )
bu= widget_button( button_area2, value='Draw',    uvalue='Draw' )

if debug eq 1 then begin
  bu= widget_button( button_area2, value='Compile', uvalue='Compile' , $
                     xsize=240, event_pro='dbg_compile')
endif

; Build date/time input fields
input_area1= widget_base( comprs_tlb, /row )
area1_col1= widget_base( input_area1, /column )
sd= cw_field( area1_col1, /string, /return_event, $
              title='Start Date', $
              value= gen_time_string(fix(state.var.start_doy96)), $
              uval='start_date_uval')
area1_col2= widget_base( input_area1, /column )
st= cw_field( area1_col2, /string, /return_event, $
              title='Start Time', $
              value= $
              gen_time_string(state.var.start_doy96 - $
                          fix(state.var.start_doy96)), $
              uval='start_time_uval')

input_area2= widget_base( comprs_tlb, /row )
area2_col1= widget_base( input_area2, /column )
ed= cw_field( area2_col1, /string, /return_event, $
              title='End   Date', $
              value= gen_time_string(fix(state.var.end_doy96)), $
              uval='end_date_uval')
area2_col2= widget_base( input_area2, /column )
et= cw_field( area2_col2, /string, /return_event, $
              title='End   Time', $
              value= gen_time_string(state.var.end_doy96 - $
                                 fix(state.var.end_doy96)), $
              uval='end_time_uval')

; Save date/time input field widget IDs
state.id.sd=sd
state.id.st=st
state.id.ed=ed
state.id.et=et

widget_control, comprs_tlb, /realize
widget_control, comprs_tlb, set_uvalue=state
end









pro fft_exception_handler, comprs_tlb, exceptionString
widget_control, comprs_tlb, get_uvalue=state
drawOnCanvas=1
displayPopup=0

if drawOnCanvas then begin

  hyd_set_plot, 'x'
  wset, state.id.reduwin

  erase, get_color_index('white')
  !p.position=0
  !p.noerase=0
  !p.background = get_color_index('white')
  !p.multi = [0,1,1]
  black= get_color_index('black')
  
  xyouts, .5, .8, exceptionString, $
          /normal, color=black, alignment=.5, charsize=2.0

endif

if displayPopup then begin
  x= widget_message(exceptionString)
endif
end



pro fft_killed, comprs_tlb
widget_control, comprs_tlb, get_uvalue=state
print,''
print, 'Some final state info.:'
print, '  state.var.start_doy96:'+strtrim(state.var.start_doy96,2)
print, '  state.var.end_doy96:  '+strtrim(state.var.end_doy96,2)
print, 'Goodbye!'
end




PRO fft, start_doy96, end_doy96, print=print

; datestr_in = 'YYYYMMDD'
; starttime_in in seconds since midnight
; stoptime_in in seconds since midnight

COMMON share
;  COMMON share, comprs_tlb

debug=0                         ; make sure this equals 0 for general releases

if n_elements( comprs_tlb ) gt 0 then begin
  if widget_info( comprs_tlb, /valid_id)  eq 0 then begin
    fft_build, start_doy96, end_doy96, debug=debug
    need_xmanager=1
  endif else begin
    need_xmanager=0
  endelse
endif else begin
  fft_build, start_doy96, end_doy96, debug=debug
  need_xmanager=1
endelse


if n_elements( start_doy96 ) ne 0 then begin 
  widget_control, comprs_tlb, get_uvalue=state
  state.var.start_doy96 = start_doy96
  state.var.end_doy96   = end_doy96
  widget_control, comprs_tlb, set_uvalue=state
endif

exceptionString=''


if need_xmanager ne 1 then begin
  widget_control, /hourglass
  fft_draw, exceptionString=exceptionString, print=print, debug=debug
end


if exceptionString ne '' then begin
  fft_exception_handler, comprs_tlb, exceptionString
endif

if need_xmanager then begin
  xmanager, 'fft', comprs_tlb, cleanup='fft_killed'
endif

;return
end
