pro fft_build, a, b, debug=debug
  COMMON share
; Define a structure for the state of the application
  id=   { $
            comprs_tlb:0L, $
            comprs_plot_area:0L, $
            sd:0L, $
            st:0L, $
            ed:0L, $
            et:0L, $
            poly_tlb:0L, $
            poly_plot_area:0L, $
            poly_but_area1:0L, $
            poly_button_p:0L, $
            poly_button_c:0L $
        }

  var=  { $
            start_doy96:a, $
            end_doy96:b, $
            operation:'compress', $
            debug:debug $
        }

  state={ $
            id:id, $
            var:var $
        }           

; Build the initial overall widget.

  comprs_tlb = widget_base( xoffset=800, yoffset=430, title='hydra_fft', /col )
  state.id.comprs_tlb=comprs_tlb
  print,'state.id.comprs_tlb      =',strtrim(state.id.comprs_tlb,2)

  plot_area = widget_draw( state.id.comprs_tlb, xsize=400, ysize=400)
  widget_control, plot_area, /realize
  widget_control, plot_area, get_value=comprs_plot_area
  state.id.comprs_plot_area = comprs_plot_area
  wset, comprs_plot_area
  print,'state.id.comprs_plot_area= ',strtrim(comprs_plot_area,2)

  button_area1 = widget_base( state.id.comprs_tlb, /row )
  bu= widget_button( button_area1, value='Compressible', uvalue='compressible' )
  bu= widget_button( button_area1, value='Polytropic',   uvalue='polytropic' )
  bu= widget_button( button_area1, value='Operation_X', uvalue='operation_X' )


  button_area2= widget_base( state.id.comprs_tlb, /row )

  bu= widget_button( button_area2, value='Print',   uvalue='Print' )
  bu= widget_button( button_area2, value='Close',   uvalue='Close' )
  bu= widget_button( button_area2, value='Help',    uvalue='Help' )
  bu= widget_button( button_area2, value='Draw',    uvalue='Draw' )

  if debug eq 1 then begin
      bu= widget_button( button_area2, value='Compile', uvalue='Compile' , $
                     xsize=240, event_pro='dbg_compile')
  endif

  input_area1= widget_base( state.id.comprs_tlb, /row )
              area1_col1= widget_base( input_area1, /column )
              sd= cw_field( area1_col1, $
                           title='Start Date', $
                           /string, $
                           value= $
                            gen_time_string(fix(state.var.start_doy96)), $
                           uval='start_date_uval', $
                           /return_event)
              area1_col2= widget_base( input_area1, /column )
              st= cw_field( area1_col2, $
                           title='Start Time', $
                           /string, $
                           value= $
                            gen_time_string(state.var.start_doy96 - $
                                        fix(state.var.start_doy96)), $
                           uval='start_time_uval', $
                           /return_event)
  input_area2= widget_base( state.id.comprs_tlb, /row )
              area2_col1= widget_base( input_area2, /column )
              ed= cw_field( area2_col1, $
                           title='End   Date', $
                           /string, $
                           value= $
                            gen_time_string(fix(state.var.end_doy96)), $
                           uval='end_date_uval', $
                           /return_event)
              area2_col2= widget_base( input_area2, /column )
              et= cw_field( area2_col2, $
                           title='End   Time', $
                           /string, $
                           value= $
                            gen_time_string(state.var.end_doy96 - $
                                              fix(state.var.end_doy96)), $
                           uval='end_time_uval', $
                           /return_event)

              state.id.sd=sd
              state.id.st=st
              state.id.ed=ed
              state.id.et=et

  widget_control, state.id.comprs_tlb, /realize

  widget_control, state.id.comprs_tlb, set_uvalue=state
end
