pro hydra_configure
   common hydra_configure_common, configure_data

   base= widget_base( /column, title='Hydra Configure' )

   if n_elements( configure_data ) eq 0 then begin
       hydra_rw_configuration, /read, stat=stat
       if stat eq 'fail' then return
   endif

   configure_data.ID_base= base

   base1= widget_base( base, /row )
   rr= cw_field( base1, $
                 value= configure_data.survey_data_dir, $
                 title= 'Survey Data Directory:', $
                 uvalue= 'cwf_survey_data_dir', $
                 /string, /frame, /column, xsize=80 )
   configure_data.ID_survey_data_dir=rr
   rr= widget_button( base1, $
                      value='Browse', $
                      uvalue='pb_browse_survey')


   base1= widget_base( base, /row )
   rr= cw_field( base1, $
                 value= configure_data.level1_data_dir, $
                 title= 'Level1 Data Directory:', $
                 uvalue= 'cwf_level1_data_dir', $
                 /string, /frame, /column, xsize=80 )
   configure_data.ID_level1_data_dir=rr
   rr= widget_button( base1, $
                      value='Browse', $
                      uvalue='pb_browse_level1')

   rr= cw_field( base, $
                 value= configure_data.l1_time_limit, $
                 title= 'Level1 Data Set Time Limit:', $
                 uvalue= 'cwf_l1_time_limit', $
                 /string, /frame, /row, xsize=4 )
   configure_data.ID_l1_time_limit=rr

   action_base= widget_base( base, /row, /frame )
   rr= widget_button( action_base, $
                      value='Okay', $
                      uvalue='pb_okay' )
   ID_save= widget_button( action_base, $
                           value='Save', $
                           UVALUE='pb_save' )
   rr= widget_button( action_base, $
                      value='Cancel', $
                      uvalue='pb_cancel' )
   rr= widget_button( action_base, $
                      value='Revert', $
                      uvalue='pb_revert' )
   rr= widget_button( action_base, $
                      value='Help', $
                      uvalue='pb_help' )

   configure_data.level1_data_dir=getenv( 'HYDRA_LEVEL1_DATA_PATH' )
   configure_data.survey_data_dir=getenv( 'HYDRA_SURVEY_DATA_PATH' )

   widget_control, configure_data.ID_survey_data_dir, $
     set_value=configure_data.survey_data_dir

   widget_control, configure_data.ID_level1_data_dir, $
     set_value=configure_data.level1_data_dir

   if !version.os_family eq 'unix' then begin
;  test to see if use can write to config file, and grey button if appropriate
     on_ioerror, no_write_access
     hydra_module= getenv('HYDRA_MODULE_PATH')
     openw, 11, hydra_module+'/hydra_configure_module.pro', /append
     close, 11
     goto, continue
     no_write_access:
     widget_control, ID_save, sensitive=0
   endif
   continue:

   geo= widget_info( base, /geo )
   x= 600- geo.xsize/2
   y= 300- geo.ysize/2

   widget_control, base, xoffset=x, yoffset=y
   widget_control, base, /realize

   xmanager, 'hydra_configure', base, /modal

   return
end

pro hydra_configure_event, event

   common hydra_configure_common, configure_data

   widget_control, event.id, get_uval= uval

   case uval of
       'pb_browse_survey': begin
           widget_control, configure_data.ID_survey_data_dir, $
             get_value=data
           r= pickfile( path=data(0), get_path=new )
           widget_control, configure_data.ID_survey_data_dir, $
             set_value=new
       end
       'pb_browse_level1': begin
           widget_control, configure_data.ID_level1_data_dir, $
             get_value=data
           r= pickfile( path=data(0), get_path=new )
           widget_control, configure_data.ID_level1_data_dir, $
             set_value=new
       end
       'pb_okay': begin
;          read widget entries
           widget_control, configure_data.ID_survey_data_dir, $
             get_value=data
           configure_data.survey_data_dir= data(0)
           widget_control, configure_data.ID_level1_data_dir, $
             get_value=data
           configure_data.level1_data_dir= data(0)
           widget_control, configure_data.ID_l1_time_limit, $
             get_value=data
           configure_data.l1_time_limit= data(0)

;          set environment variables
           hydra_module= getenv('HYDRA_MODULE_PATH')
           ss= 'setenv, ''HYDRA_LEVEL1_DATA_PATH='+$
             configure_data.level1_data_dir+''''
           r=execute(ss)
           ss= 'setenv, ''HYDRA_SURVEY_DATA_PATH='+$
             configure_data.survey_data_dir+''''
           r=execute(ss)
           ss= 'setenv, ''HYDRA_L1_SPEC_TIME_LIMIT='+$
             configure_data.l1_time_limit+''''
           r=execute(ss)

           widget_control, event.top, /destroy
       end
       'pb_save': begin
;          read widgets
           widget_control, configure_data.ID_survey_data_dir, $
             get_value=data
           configure_data.survey_data_dir= data(0)
           widget_control, configure_data.ID_level1_data_dir, $
             get_value=data
           configure_data.level1_data_dir= data(0)
           widget_control, configure_data.ID_l1_time_limit, $
             get_value=data
           configure_data.l1_time_limit= data(0)

;          set environment variables and save to file
           hydra_rw_configuration, /write, stat=stat
           widget_control, event.top, /destroy
       end
       'pb_cancel': begin
           widget_control, event.top, /destroy
       end
       'pb_revert': begin
           hydra_rw_configuration, /read
           widget_control, configure_data.ID_survey_data_dir, $
             set_value=configure_data.survey_data_dir
           widget_control, configure_data.ID_level1_data_dir, $
             set_value=configure_data.level1_data_dir
       end
       'pb_help': begin
           xdisplayfile,module_helpfile('hydra_configure.help')
       end
       else: print, 'hydra_configure: internal error.'
   endcase
   return
end


