;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO hydra_fv_panel_event, event
;* 
;* DESCRIPTION:  
;*	This processes events from the XMANAGER.
;*	As this example does not extend the basic functionality of plot-
;*	editors, it directly calls the default-handler, PAPCO_PANEL_Event
;*
;* INPUTS:       
;*	event		an XManager event
;*			
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:       
;*     written august 1995, Andreas Keese
;*
;***************************************************************************
PRO hydra_fv_panel_event, event, uvalue=uval
   COMMON hydra_fv_panel_DATA, widgetData
   common rp_hydra_fv_common, fv_out_header, fv_ele, fv_ion

   species= widgetData.typeVector(0)

   hydra_fv_rw_list, /read, species, $
     fv_header, fv_data, fv_input_global

   if n_elements( uval ) eq 0 then begin
       WIDGET_CONTROL,GET_UVALUE=uval, event.id
   endif

   IF strleft(uval, 8) EQ 'spb_type' THEN BEGIN
       widgetData.typeVector(0)= fix(strfrom(uval, 8))
       species= widgetData.typeVector(0)
       hydra_fv_rw_list, /read, species, $
         fv_header, fv_data, fv_input_global
       widgetData.zscalemin= fv_input_global.control.zmin
       widgetData.zscalemax= fv_input_global.control.zmax   
       widget_control, widgetData.ef_zScaleFrom, $
         set_value=widgetData.zscalemin 
       widget_control, widgetData.ef_zScaleTo, $
         set_value=widgetData.zscalemax 
   ENDIF else IF strleft(uval, 9) EQ 'spb_trace' THEN BEGIN
       widgetData.typeVector(1)= fix(strfrom(uval, 9))
   endif else if uval eq 'pb_listman' then BEGIN
       if n_elements( fv_data ) eq 1 and $ ; list is empty
         widgetData.filename ne '' then begin 
           hydra_fv_panel_event, uvalue='hfw_load'
       endif
       hydra_fv_control, species=species, group=event.top
       redraw=1
   endif else if uval eq 'pb_reload' then begin
       if n_elements( fv_data ) gt 1 then begin           
           fv_data(1:*).reload=1
           fv_data(1:*).fv_input= replicate(fv_input_global, $
                                            n_elements(fv_data)-1 )
           fv_out_header.reload(species)=1
           
           hydra_fv_rw_list, /write, species, $
             fv_header, fv_data, fv_input_global
           redraw=1
       endif
   endif else if uval eq 'pb_control' then BEGIN       
       state= fv_input_global
       species_store= fv_input_global.species
       if species eq 0 then $
         control_ele= fv_input_global.control $
       else $
         control_ion= fv_input_global.control 

;      sorry this is confusing, I'm working to clean it up.  The
;      uvalue of slice base is really what is modified. 
       widget_state= { state:fv_input_global, $
                       control_ele:fv_input_global.control, $
                       control_ion:fv_input_global.control }
       widget_control, widgetData.slice_base, set_uvalue= widget_state
       fpitch_control, fv_input_global, widgetData.slice_base, /modal
       widget_control, widgetData.slice_base, get_uvalue= widget_state
       fv_input_global= widget_state.state

       if n_elements( fv_data ) gt 1 then begin
           for i=1,n_elements( fv_data )-1 do begin
               fv1= fv_data[i].fv_input              
               fv_data[i].fv_input= fv_input_global
               fv_data[i].fv_input.mode.t0= fv1.mode.t0
               fv_data[i].fv_input.mode.last_block= fv1.mode.last_block
               fv_data[i].fv_input.mode.path= fv1.mode.path
               fv_data[i].fv_input.mode.hres= fv1.mode.hres
               fv_data[i].fv_input.mode.lres= fv1.mode.lres               
           endfor
           redraw=1
           hydra_fv_panel_event, uvalue='pb_reload'
       endif
       hydra_fv_rw_list, /write, species, $
         fv_header, fv_data, fv_input_global
   endif else if uval eq 'hfw_save' or uval eq 'hfw_create' then begin
       common hydra_fv_common, $
         fve_header, fve_data, fve_input_global, $
         fvi_header, fvi_data, fvi_input_global
       message, 'Saving to '+widgetData.filename, /cont
       save, file= widgetData.filename,  $
         fve_header, fve_data, fve_input_global, $
         fvi_header, fvi_data, fvi_input_global
       r= messageBox( ['I have saved your list to ', $
                       widgetData.filename], ['Thanks'], /center, $
                      title='File Status' )
       hydra_file_widget_check_status, widgetData
   endif else if uval eq 'hfw_load' then begin
       hydra_fv_load, widgetData.filename, status=status
       hydra_fv_panel_event, uvalue='pb_reload'
       if status eq 'success' then begin           
           r= messageBox( ['I have restored your list from ', $
                           widgetData.filename], ['Thanks'], /center, $
                          title='File Status' ) 
       endif else begin
           if status eq 'structure_conflict' then begin
               r= messageBox( ['Structure conflict encountered ',$
                               'while loading file ', $
                               widgetData.filename,status, $
                               'Restart IDL and load this file', $
                               'before others.'], ['Thanks'], /center, $
                              title='File Status' ) 
           endif
       endelse
       redraw=1
   endif else if uval eq 'nrow' then begin
       widget_control, event.id, get_value=nrow
       widgetData.typeVector(2)= nrow
   endif else if strleft( uval,3 ) eq 'hfw' then begin
       widgetData= hydra_file_widget_event( event, widgetData )
   endif else begin
       widgetData=PAPCO_panel_Event(event, widgetData)
   ENDELSE
   
   if keyword_set( redraw ) then begin
       widgetData.typeVector(3)= widgetData.typeVector(3)+1
       print, widgetData.typeVector(3)
   endif
END


;***************************************************************************
;***************************************************************************
;* 
;* FILE:
;*    $PAPCO_PATH/hydra_fv_panel.pro
;* 
;*    This file belongs to the PAPCO-project. See $PAPCO_PATH/papco.pro for
;*    further information.
;*
;* DESCRIPTION: 
;*    This file contains a demonstration on how to implement a PAPCO-
;*    panel-editor. It makes use of all the features provided by 
;*    $PAPCO_PATH/papco_panel.pro
;*    It constructs an editor for a very simple PAPCO-plot, that has only
;*    default-functionality.
;*
;* FILES YOU MAY WANT TO READ
;*       $PAPCO_PATH/papco_conventions.text     which conventions were used
;*						when developing ?
;*	 $PAPCO_PATH/papco_variables.text	what structures and global
;*						variables are used by 
;*						which file ?
;*
;* USED MODULES:
;*    For a list of files, that are needed for PAPCO to run, read the 
;*    file addpapco_init.PRO in $PAPCO_MODULES
;*
;* COMMON-BLOCKS:
;*    hydra_fv_panel_DATA	contains the window-information
;*
;* STRUCTURES:
;*    This module creates one concrete structure, that inherits from the 
;*    PAPCO_PANEL_EDITOR-structure (see $PAPCO_PATH/papco_panel.pro for a
;*    description). 
;*       {hydra_fv_panel_DATA, 
;*	     ; imagine the PAPCO_PANEL_EDITOR-structure was inserted...
;*	      
;*    For a more complete description see $PAPCO_PATH/papco_variables.text
;*
;* OVERVIEW:
;*    This function creates the editor-window:
;*       FUNCTION  hydra_fv_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;*    You might try this:
;*	 print, hydra_fv_panel(PAPCO_getPlotInfoStruct())
;*       which calls up the window.
;*
;* MODIFICATION HISTORY:       
;*     august 1995, written by A.Keese
;*     December 1995, modified by R.Friedel at Goddard
;*     
;***************************************************************************



;***************************************************************************

;***************************************************************************
;* 
;* FUNCTION:     
;*      FUNCTION  hydra_fv_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;* 
;* DESCRIPTION:  
;*	Open an editor for a panelplot.
;*	Its window is constructed using the methods defined in the file
;*	$PAPCO_PATH/papco_panel.pro
;*	When the user presses the 'Done'- or the 'Cancel'-Button, the values 
;*	changed by the event-methods of papco_panel.pro are returned.
;*	The returned value is a structure containing those values and a flag,	
;*	'canceled', which the caller may read out to check, whether the 
;*	window was closed using the 'Cancel' or the 'Done'-Button.
;*
;* INPUTS:       
;*	aPlotInfo	a structure of the PAPCO_PLOTINFO-type
;*			this structure is edited in the window.
;*     
;* KEYWORDS:
;* 	GROUP		a WIDGET_BASE
;*			when specified, this is used as GROUP_LEADER
;*	ACTION		a string
;*			when specified, the 'Done'-Button is labeled with it
;*		        if not specified, the 'Done'-Button is labeled 'Done'
;*
;* OUTPUT:	 
;*      a default-structure of type PAPCO_PANEL_EDITOR_RETURN. Though this
;*	type is nowhere defined, I like to think of it as virtually existing
;*	data-type. 
;*	All the functions in $PAPCO_PATH/papco.pro that edit plots or add new
;*	ones, expect the opened editor-windows to return a structure containing
;*	at last some fields. Those fields might make up a structure, but as no
;*	program defines the structure-type PAPCO_PANEL_EDITOR_RETURN, this 
;*	poor structure is not alive but only virtual.
;*	The return-values of plot-editors have to expand this structure - I 
;*	like to think, that they inherit from that structure - and contain at
;*	least those fields:
;*   		{$
;*			canceled:1, $
;*	    		panelHeight:1, $
;*	    		channel:0, $
;*	    		typeVector:[0,0,0,0], $ 
;*	    		manualYScaling:0 $
;*	    		yScaleMin:LONG(1), $
;*	    		yScaleMax:LONG(1), $
;*	    		panelKind:'some string'}
;*
;*      Additionally, some Panel-editors may return these fields in
;*      structure:
;*               {$
;*		        color:1, $
;*			plotStyle:1}
;*			
;*      For an enhanced description read $PAPCO_PATH/papco_variables.text
;*
;* CALLING SEQUENCE:
;*	aPlotInfoStruct=PAPCO_getPlotInfoStruct()
;*
;* MODIFICATION HISTORY:       
;*     written august 1995, Andreas Keese
;*
;***************************************************************************
; typeVector(0)  is species
; typeVector(1)  is up/down traces
; typeVector(2)  is explicit nrow
; typeVector(3)  is used to indicate state change outside of state vector

FUNCTION  hydra_fv_panel, aPlotInfo, GROUP=group, ACTION=ACTION
   COMMON hydra_fv_panel_DATA, widgetData

; if GROUP is not specified, the group-leader will be the desktop
   IF NOT KEYWORD_SET(GROUP) THEN GROUP=0

; set the label for the action-button
   IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'

; the routines used by papco_panel.pro define tags for a structure. Those
; tags will be stored in the structure 'additionalWData'. When you realize the
; window, you have to add your own window-specific data to that structure 
; and afterwards assign it to widgetData.
   additionalWData={canceled:1}

;--- create the base-window ----------------------------------------------------
   panel_base=WIDGET_BASE(title=aPlotInfo.panelKind,$
	 column=1, $
	 GROUP_LEADER=group)

;--- the first part of the window will consist in the widgets ------------------
;    that control the height of that plot
   widgets=PAPCO_panel_AddHeightWidgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

; --- Choose plot type------------------------------------------------------ 
   type_base=WIDGET_BASE(panel_base, /FRAME, row=1, /EXCLUSIVE) 

   typeNames=['Electrons', $
              'Ions' ]
   spb_type=lonarr(N_ELEMENTS(typeNames))
   
   FOR i=0, N_ELEMENTS(typeNames)-1 DO begin
       spb_type(i)=WIDGET_BUTTON(type_base, $
                                 VALUE=typeNames(i), $
                                 UVALUE='spb_type'+strtrim(string(i), 2))
       WIDGET_CONTROL, spb_type(i), $
         SET_BUTTON= aPlotInfo.typevector(0) eq i
   endfor
; end Choose plot type ------------------------------------------------- 

; --- Choose up or down trace direction type---------------------
   type_base=WIDGET_BASE(panel_base, /FRAME, row=1, /EXCLUSIVE) 
   
   typeNames=['Up Traces',$
              'Down Traces' ]
   spb_type=lonarr(N_ELEMENTS(typeNames))
   
   FOR i=0, N_ELEMENTS(typeNames)-1 DO begin
       spb_type(i)=WIDGET_BUTTON(type_base, $
                                 VALUE=typeNames(i), $
                                 UVALUE='spb_trace'+strtrim(string(i), 2))
       WIDGET_CONTROL, spb_type(i), $
         SET_BUTTON= aPlotInfo.typevector(1) eq i
   endfor
; end Choose up or down trace direction type---------------------

;  Number of rows specification.
   r= cw_field( panel_base, title='Number of Rows (0=auto): ', $
                /int, value=aPlotInfo.typevector(2), $
                xsize=2, uvalue='nrow', /return_ev )
   
;  list filename
   widgets= hydra_File_Widget(panel_base, aPlotInfo, /create, /load, /save)
   additionalWData=create_struct(widgets, additionalWData)      
   
;  opening list for read only purposes!
   species= aPlotInfo.typevector(0)
   hydra_fv_rw_list, /read, species, $
     fv_header, fv_data, fv_input_global

;  reload and listman buttons
   button_base= widget_base( panel_base, /frame, /row )
   r= widget_button( button_base, value='Reload', uvalue='pb_reload' )
   r= widget_button( button_base, value='List Manager', uvalue='pb_listman' )
   r= widget_button( button_base, value='Control', uvalue='pb_control' )

; ---add z range scaling widgets
   widgets=PAPCO_PANEL_AddZScale_Widgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;  We need a base to store the control structure for fpitch_control.
   r= widget_base( panel_base )
   additionalWData=create_struct( additionalWData, { slice_base:r } )

;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window.
   widgets=PAPCO_panel_AddActionButtons(panel_base, Action, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;--- now, create the structure that keeps the panel-window data. You
;    always need to specify the help-file, and your structure must
;    always contain the 'additionalWData'.
   thisWidgetsData={helpfile:'hydra_fv_panel.help', $
                    typevector:aPlotInfo.typeVector, $
                    spb_type:spb_type}

   widgetData=PAPCO_PANEL_CreateWidgetData(thisWidgetsData, additionalWData)

;--- realize the window
   PAPCO_Panel_Realize, panel_base, widgetData

; As this is a function that will return all changes made by the
; user, the xmanager has to be called with the keyword MODAL. If we
; wouldn't specify /MODAL, no changes would be reportet but the 
; data contained in aPlotInfo would be returned.
   xmanager, 'hydra_fv_panel', panel_base, /MODAL

; the returned data consists of the standard-data inherited from
; PAPCO_PANEL.PRO and your new data - e.g. the typeVector-tag.
   returnData={ typeVector:widgetData.typeVector }

   additionalRData=PAPCO_panel_ReturnData(widgetData)

   return, create_struct(ReturnData, additionalRData)
END

   




















