pro hydra_kp_configure
   common hydra_configure_common, configure_data

   base= widget_base( /column, title='Hydra KP Configure' )
   
   if n_elements( configure_data ) eq 0 then begin
       hydra_rw_configuration, /read, stat=stat
       if stat eq 'fail' then return           
   endif
       
   configure_data.ID_base= base

;  add Survey Data Directory Widgets
   base1= widget_base( base, /row )
   rr= cw_field( base1, $
                 value= configure_data.survey_data_dir, $
                 title= 'Survey Data Directory (LOW RES KPs):', $
                 uvalue= 'cwf_survey_data_dir', $
                 /string, /frame, /column, xsize=80 )
   configure_data.ID_survey_data_dir=rr
   rr= widget_button( base1, $
                      value='Browse', $
                      uvalue='pb_browse_survey')   
   
   
;  add Level1 Calibration Data Directory Widget
   base1= widget_base( base, /row )   
   rr= cw_field( base1, $
                 value= configure_data.level1cal_data_dir, $
                 title= 'Level1 Cal. Data Directory (HIGH RES KPs):', $
                 uvalue= 'cwf_level1cal_data_dir', $
                 /string, /frame, /column, xsize=80 )
   configure_data.ID_level1cal_data_dir=rr
   rr= widget_button( base1, $
                      value='Browse', $
                      uvalue='pb_browse_level1cal')

;  add Level1 Data Set Time Limit Widget
   rr= cw_field( base, $
                 value= configure_data.l1_time_limit, $
                 title= 'Level1 Data Set Time Limit (min):', $
                 uvalue= 'cwf_l1_time_limit', $
                 /string, /frame, /row, xsize=4 )
   configure_data.ID_l1_time_limit=rr
  

;  add Action Buttons
   action_base= widget_base( base, /row, /frame )
   rr= widget_button( action_base, $
                      value='Okay', $
                      uvalue='pb_okay' )
   ID_save= widget_button( action_base, $
                           value='Save', $
                           UVALUE='pb_save' )
   rr= widget_button( action_base, $
                      value='Cancel', $
                      uvalue='pb_cancel' )   
   rr= widget_button( action_base, $
                      value='Revert', $
                      uvalue='pb_revert' )
   rr= widget_button( action_base, $
                      value='Help', $
                      uvalue='pb_help' )


;  test to see if use can write to config file, and grey button if appropriate
   hydra_module= getenv('HYDRA_MODULE_PATH')
   spawn, 'test -w '+hydra_module+'/hydra_configure_module.pro ; echo $?', $
     result, /sh
   if fix(result(0)) then begin
       widget_control, ID_save, $
         sensitive=0
   endif

;  center widget on screen
   geo= widget_info( base, /geo )
   x= 600- geo.xsize/2
   y= 300- geo.ysize/2

   widget_control, base, xoffset=x, yoffset=y

;  realize and start xmanager with widget in modal mode.
   widget_control, base, /realize
   xmanager, 'hydra_kp_configure', base, /modal

   return
end

pro hydra_kp_configure_event, event

   common hydra_configure_common, configure_data

   widget_control, event.id, get_uval= uval

   case uval of 
       'pb_browse_survey': begin
           widget_control, configure_data.ID_survey_data_dir, $
             get_value=data
           spawn, 'ls -d '+data(0), data
           r= pickfile( path=data(0), get_path=new, title='Survey Data Dir' )
           widget_control, configure_data.ID_survey_data_dir, $
             set_value=new
       end           
       'pb_browse_level1cal': begin
           widget_control, configure_data.ID_level1cal_data_dir, $
             get_value=data
           spawn, 'ls -d '+data(0), data
           r= pickfile( path=data(0), get_path=new, title='Level 1 Cal. Data Dir' )
           widget_control, configure_data.ID_level1cal_data_dir, $
             set_value=new
       end           
       'pb_okay': begin
;          read widget entries
           widget_control, configure_data.ID_survey_data_dir, $
             get_value=data
           configure_data.survey_data_dir= data(0)
           widget_control, configure_data.ID_level1cal_data_dir, $
             get_value=data
           configure_data.level1cal_data_dir= data(0)
           widget_control, configure_data.ID_l1_time_limit, $
             get_value=data
           configure_data.l1_time_limit= data(0)

;          set environment variables
           hydra_module= getenv('HYDRA_MODULE_PATH')
           ss= 'setenv, ''HYDRA_LEVEL1CAL_DATA_PATH='+$
             configure_data.level1cal_data_dir+''''
           r=execute(ss)
           ss= 'setenv, ''HYDRA_SURVEY_DATA_PATH='+$
             configure_data.survey_data_dir+''''
           r=execute(ss)
           ss= 'setenv, ''HYDRA_L1_SPEC_TIME_LIMIT='+$
             configure_data.l1_time_limit+''''
           r=execute(ss)

           widget_control, event.top, /destroy           
       end
       'pb_save': begin
;          read widgets
           widget_control, configure_data.ID_survey_data_dir, $
             get_value=data
           configure_data.survey_data_dir= data(0)
           widget_control, configure_data.ID_level1cal_data_dir, $
             get_value=data
           configure_data.level1cal_data_dir= data(0)
           widget_control, configure_data.ID_l1_time_limit, $
             get_value=data
           configure_data.l1_time_limit= data(0)

;          set environment variables and save to file
           hydra_rw_configuration, /write, stat=stat
           widget_control, event.top, /destroy           
       end
       'pb_cancel': begin
           widget_control, event.top, /destroy
       end
       'pb_revert': begin
           hydra_rw_configuration, /read
           widget_control, configure_data.ID_survey_data_dir, $
             set_value=configure_data.survey_data_dir
           widget_control, configure_data.ID_level1cal_data_dir, $
             set_value=configure_data.level1cal_data_dir
       end
       'pb_help': begin
           xdisplayfile,module_helpfile('hydra_kp_configure.help')
       end
       else: print, 'hydra_kp_configure: internal error.'
   endcase
   return
end

   
