pro hydra_label_maker, tpp=tpp, spp=spp

common hydra_label_maker_block, $
  tpp_spec_lab, tpp_res_lab, tpp_res_rstr, tpp_frame_lab, tpp_var_lab, $
  spp_spec_lab, spp_res_lab, spp_res_rstr, spp_frame_lab, spp_var_lab

@hd_units

gyro_label = '!sG!r/'
rchi2_label = '!7v!x!s!d!7m!x!r!u2!n'
ux_label = 'U!dx!n'
uy_label = 'U!dy!n'
uz_label = 'U!dz!n'
umag_label = 'U!dmag!n'
bx_label = 'B!dx!n'
by_label = 'B!dy!n'
bz_label = 'B!dz!n'
bmag_label = 'B!dmag!n'
ktparl_label = 'kT!d!9#!x!n'
ktperp_label = 'kT!d!9x!x!n'
uparl_label = 'U!d!9#!x!n'
uperpmag_label = 'U!d!9x!x!n'
uperpx_label = 'U!d!9x!x,x!n'
uperpy_label = 'U!d!9x!x,y!n'
uperpz_label = 'U!d!9x!x,z!n'
beta_label = '!7b!x'

if (keyword_set(tpp) or keyword_set(spp)) then begin

; The following labels are used by:
;         hydra_tpp_panel.pro
;         r_hydra_tpp.pro
;         p_hydra_tpp.pro
; So if you change any, or add any, be sure to propagate the changes
; to these routines!!!!

    tpp_spec_lab = ['e-','H+','He+','He++','O+']
    tpp_res_lab = ['1.15s','3.45s','5.75s','12.65s']
    tpp_res_rstr = ['1','2','3','6']
    tpp_frame_lab = ['payload','GSE','GSM']
    
    nvar = 29                   ; This must be exact size, no bigger
    tpp_var_lab = strarr(nvar,4) ; ORDER: Panel, Descriptor, Plot, Units
    tpp_var_lab(0,*) = ['Density','den','N',unit_pcm3]
    tpp_var_lab(1,*) = ['kT','kt','kT',unit_eV]
    tpp_var_lab(2,*) = ['kTparl','ktparl',ktparl_label,unit_eV]
    tpp_var_lab(3,*) = ['kTperp','ktperp',ktperp_label,unit_eV]
    tpp_var_lab(4,*) = ['Ux','ux',ux_label,unit_kmps]
    tpp_var_lab(5,*) = ['Uy','uy',uy_label,unit_kmps]
    tpp_var_lab(6,*) = ['Uz','uz',uz_label,unit_kmps]
    tpp_var_lab(7,*) = ['Umag','umag',umag_label,unit_kmps]
    tpp_var_lab(8,*) = ['Uparl','uparl',uparl_label,unit_kmps]
    tpp_var_lab(9,*) = ['Uperpx','uperpx',uperpx_label,unit_kmps]
    tpp_var_lab(10,*) = ['Uperpy','uperpy',uperpy_label,unit_kmps]
    tpp_var_lab(11,*) = ['Uperpz','uperpz',uperpz_label,unit_kmps]    
    tpp_var_lab(12,*) = ['Uperpmag','uperpmag',uperpmag_label,unit_kmps]
    tpp_var_lab(13,*) = ['Anisotropy','anis',ktparl_label+'/'+ktperp_label,' ']
    tpp_var_lab(14,*) = ['Angyrotropy','angyro',gyro_label,' ']
    tpp_var_lab(15,*) = ['Plasma Beta','beta',beta_label,' ']
    tpp_var_lab(16,*) = ['Patch Status','pstat','patch_stat',' ']
    tpp_var_lab(17,*) = ['Min. Fit Energy','minE','E!s!dmin!r!ufit!n',unit_eV]
    tpp_var_lab(18,*) = ['Max. Fit Energy','maxE','E!s!dmax!r!ufit!n',unit_eV]
    tpp_var_lab(19,*) = ['Rchi2','rchi2',rchi2_label,' ']
    tpp_var_lab(20,*) = ['Rchi2 All','rchi2all',rchi2_label+' All',' ']
    tpp_var_lab(21,*) = ['# of Fit Points','npatch','npatch',' ']
    tpp_var_lab(22,*) = ['Parl E.V.-B Angle','angleb','!9#!x-E.V. - B Angle',unit_degrees]
    tpp_var_lab(23,*) = ['Bx','bx',bx_label,unit_nt]
    tpp_var_lab(24,*) = ['By','by',by_label,unit_nt]
    tpp_var_lab(25,*) = ['Bz','bz',bz_label,unit_nt]
    tpp_var_lab(26,*) = ['Bmag','bmag',bmag_label,unit_nt]
    tpp_var_lab(27,*) = ['B Status','bstat','bstat',' ']
    tpp_var_lab(28,*) = ['B Errorcone Angle','bcangle','B Errorcone',unit_degrees]

    spp_spec_lab = tpp_spec_lab
    spp_res_lab = tpp_res_lab
    spp_res_rstr = tpp_res_rstr
    spp_var_lab = tpp_var_lab
    spp_frame_lab = tpp_frame_lab
endif

return
end


    
