pro drawslice_hydra_ppa, panelNr, seconds, yvalue
   common time, xut1, xut2

   common drawslice_hydra_ppa_buf, buf_timerange, buf_date, $
     buf_counts, buf_time, buf_dt, ppa_info

   if n_elements( xut1 ) eq 1 then begin ; stand-alone operation
       convert_T90_to_date, xut1, year, doy, hour, minute, second, $
         month, cmonth, day_om
       date= year*10000L + month*100 + day_om
       tmid= hour*3600L + minute*60L + second + seconds
   endif else begin
       date= 19960919
       tmid= seconds
   endelse
   
   if n_elements( buf_timerange ) ne 0 then begin
       if buf_date eq date and $
         buf_timerange(0) le tmid and $
         buf_timerange(1) ge tmid then begin
           isloaded=1
       endif else begin
           isloaded=0
       endelse
   endif else isloaded=0
   
;   isloaded=0
   if not isloaded then begin
       init_ppa_l1, date, ppa_info
       
       if (xut2-xut1) ne ( ( xut2 mod 86400 ) - ( xut1 mod 86400 ) ) then begin
           message, 'Can''t handle day boundries.', /cont
           return
       endif
       time_range= ( [ xut1, xut2 ] mod 86400 ) / 3600.
       recnum= find_ppa_recnum( time_range, ppa_info )

       s= sort( ppa_info.energy )

       read_ppa_l1, recnum, ppa_data, ppa_info
       buf_counts= float( ppa_data(*).counts(*,s) )
       
       viewtime= ppa_data(*).viewtime( *, s )
       validb= make_array( 120, value=1 ) # ( ppa_data(*).validb_flag(s) )(*)
       r= where( validb eq 0 )
       if r(0) ne -1 then viewtime( r ) = 0.
       
       rnv= where( viewtime eq 0. )
       rv= where( viewtime gt 0. )
       
       rzero= where( buf_counts eq 0. )
       if rzero(0) ne -1 then buf_counts( rzero ) = 0.1
       
       if rnv(0) ne -1 then buf_counts( rnv ) = 1e-20 
       if rv(0) ne -1 then buf_counts( rv ) = buf_counts( rv ) / viewtime( rv )
       
       buf_time= ppa_data(*).time
       buf_dt= ppa_data(*).dt

       buf_timerange= time_range * 3600.
       buf_date= date
   endif
          
   r= where( tmid - buf_time ge 0, count ) 
   if count eq 0 then r=0 else r=r(count-1)
   
   delta_bin= ( !pi / 256 ) / !dtor   

   alpha1= indgen(256) * delta_bin
   alpha2= alpha1 + delta_bin
   alpha= reform ( [ alpha1, alpha2 ], n_elements(alpha1), 2 )

   timestr= hydra_hms( buf_time(r) ) + ' - ' + $
     hydra_hms( buf_time(r)+buf_dt(r) )

   zrange=[1e-1,1e1]

   s= sort( ppa_info.energy )

;  erase the old title
   polyfill, [0,1,1,0,0],[.95,.95,1,1,.95], color=0, /normal
   !p.position=0
   !p.region=[0,0,0.8,1]
   hydra_plotcolor, buf_counts(ppa_info.ialpha,*,r), alpha, $
     ppa_info.energy(s), $
     /zlog, zrange=zrange, $
     nodata=1e-20, $
     title='PPA Count Rate '+timestr, $
     ytitle='Energy', xtitle='Pitch Angle', /ylog, color=1, /xfilled, dy=0.02
;   hydra_colorplot, buf_counts(ppa_info.ialpha,*,r), $
;     /zlog, zrange=zrange, $
;     nodata=1e-20, $
;     title='PPA Count Rate '+timestr, $
;     ytitle='Energy', xtitle='Pitch Angle', color=[2,22]
   !p.region=0

   hydra_color_bar, /zlog, zrange=zrange, ztit='cps'

   return
end

