pro hydra_spec_options_event, event

   common hydra_user_configure_common, user_configure_data, $
     user_configure_data_tmp

   widget_control, event.id, get_uval= uval

   case uval of
       'pb_shift': user_configure_data_tmp.spec_shift=event.select
       'pb_dJdE': user_configure_data_tmp.spec_dJdE=event.select
       'pb_okay': begin
;          read temporary structure and widget entries
           user_configure_data.spec_shift= $
             user_configure_data_tmp.spec_shift
           user_configure_data.spec_dJdE= $
             user_configure_data_tmp.spec_dJdE

           widget_control, event.top, /destroy
       endif
       'pb_save': begin
;          read widgets
           user_configure_data.spec_shift= $
             user_configure_data_tmp.spec_shift
           user_configure_data.spec_dJdE= $
             user_configure_data_tmp.spec_dJdE

;          set environment variables and save to file
           hydra_rw_user_configuration, /write, stat=stat
           widget_control, event.top, /destroy
       endif
       'pb_cancel': begin
           widget_control, event.top, /destroy
       endif
       'pb_revert': begin
           hydra_rw_user_configuration, /read
           widget_control, user_configure_data.ID_spec_shift, $
             set_value=byte(user_configure_data.spec_shift)
           widget_control, user_configure_data.ID_spec_dJdE, $
             set_value=byte(user_configure_data.spec_dJdE)
       endif
       'pb_help': begin
           xdisplayfile,module_helpfile('hydra_spec_user_configure.help')
       end
       else: print, 'hydra_spec_options: internal error.'
   endcase
   return
end


pro hydra_spec_options

   common hydra_user_configure_common, user_configure_data, $
     user_configure_data_tmp

   base= widget_base( /column, title='Hydra Spec Configure' )

   if n_elements( user_configure_data ) eq 0 then begin
       hydra_rw_user_configuration, /read, stat=stat
       if stat eq 'fail' then return
   endif

   user_configure_data.ID_base= base

;  add Options Widgets
   base1= widget_base( base, /column, /nonexclusive )
   rr= widget_button( base1, $
                      value='Shift Energies by S/C Potential', $
                      uvalue='pb_shift')
   user_configure_data.ID_spec_shift=rr
   widget_control, rr, set_button= user_configure_data.spec_shift

   rr= widget_button( base1, $
                      value='dJ/dE colorbar label', $
                      uvalue='pb_dJdE')
   user_configure_data.ID_spec_djde=rr
   widget_control, rr, set_button= user_configure_data.spec_dJdE

;  add Action Buttons
   action_base= widget_base( base, /row, /frame )
   rr= widget_button( action_base, $
                      value='Okay', $
                      uvalue='pb_okay' )
   ID_save= widget_button( action_base, $
                           value='Save', $
                           UVALUE='pb_save' )
   rr= widget_button( action_base, $
                      value='Cancel', $
                      uvalue='pb_cancel' )
   rr= widget_button( action_base, $
                      value='Revert', $
                      uvalue='pb_revert' )
   rr= widget_button( action_base, $
                      value='Help', $
                      uvalue='pb_help' )


   if !version.os_family eq 'unix' then begin
;  test to see if use can write to config file, and grey button if appropriate
;   hydra_module= getenv('HYDRA_MODULE_PATH')
      spawn, 'test -w '+ user_configure_data.user_configure_data_file +$
        ' ; echo $?', result
      if fix(result(0)) then begin
        widget_control, ID_save, $
          sensitive=0
      endif
   endif

;  center widget on screen
   geo= widget_info( base, /geo )
   x= 600- geo.xsize/2
   y= 300- geo.ysize/2

   widget_control, base, xoffset=x, yoffset=y

;  realize and start xmanager with widget in modal mode.
   widget_control, base, /realize
   xmanager, 'hydra_spec_options', base, /modal

   return
end

