;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO hydra_spec_panel_event, event
;* 
;* DESCRIPTION:  
;*	This processes events from the XMANAGER.
;*	As this example does not extend the basic functionality of plot-
;*	editors, it directly calls the default-handler, PAPCO_PANEL_Event
;*
;* INPUTS:       
;*	event		an XManager event
;*			
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:       
;*     written august 1995, Andreas Keese
;*
;***************************************************************************
PRO hydra_spec_panel_event, event
   COMMON hydra_spec_panel_DATA, widgetData
   WIDGET_CONTROL,GET_UVALUE=uval, event.id

   common hydra_spec_data, $
     data_context, $            ; selects current data set
     spec_header, $
     spec_data, $
     spec_aligned_data, $
     spec_perp_data, $
     spec_opposed_data, $
     hr_spec_data, $
     hr_spec_aligned_data, $
     hr_spec_perp_data, $
     hr_spec_opposed_data

   value_idx= strlen( uval ) - 1 
   IF strleft(uval, 8) EQ 'spb_type' THEN BEGIN
       widgetData.typeVector(0)=fix(strfrom(uval, 8))
   ENDIF ELSE IF strleft(uval, 9) EQ 'spb_pitch' then begin
       widgetData.typeVector(2)=fix(strfrom(uval, 9))
       data_context= hyd_dc( widgetData.typeVector(1),widgetData.typeVector(2))
   ENDIF ELSE IF strleft(uval, 8) EQ 'spb_tres' then begin
       widgetData.typeVector(1)=fix(strfrom(uval, 8))       
       data_context= hyd_dc( widgetData.typeVector(1),widgetData.typeVector(2))
   endif else if strleft(uval, value_idx) eq 'spb_shift' THEN BEGIN 
       widgetdata.typeVector(3)= $
         widgetdata.typeVector(3) and ( not long(1) ) $
         or 1-fix(strfrom(uval, value_idx))
       widget_control, event.id, $
         set_uvalue= 'spb_shift'+ strtrim( widgetData.typeVector(3) and 1,2 )
   endif else if strleft(uval, value_idx) eq 'spb_Zunits' THEN BEGIN 
       widgetdata.typeVector(3)= $
         widgetdata.typeVector(3) and ( not long(14) ) $
         or fix(strfrom(uval, value_idx)*2)
   ENDIF ELSE if uval eq 'spb_l1_options' then begin
       hydra_spec_l1_options, widgetData, parent=event.top
   endif else if uval eq 'spb_info' then begin
       hydra_display_info, /spec
   endif else if uval eq 'spb_idlsave' then begin
       hydra_rw_idlsav, /write, /spec
   endif else if uval eq 'spb_idlload' then begin
       hydra_rw_idlsav, /read, /spec       
   endif else if uval eq 'spb_reload' then begin
       data_context= hyd_dc( widgetData.typeVector(1),widgetData.typeVector(2))
       if n_elements(spec_header) gt 0 then $
         spec_header(data_context).reload_flag=1
   endif else if uval eq 'hfw_save' or uval eq 'hfw_create' then begin
       message, 'Saving to '+widgetData.filename, /cont
       save, file=widgetData.filename, /verbose, $
         data_context, $        ; selects current data set
         spec_header, $
         spec_data, $
         spec_aligned_data, $
         spec_perp_data, $
         spec_opposed_data, $
         hr_spec_data, $
         hr_spec_aligned_data, $
         hr_spec_perp_data, $
         hr_spec_opposed_data
       r= messageBox( ['I have saved all loaded ', 'spectrogram data to ', $
                       widgetData.filename], ['Thanks'], /center, $
                      title='File Status' )
       hydra_file_widget_check_status, widgetData
   endif else if uval eq 'hfw_load' then begin
       restore, file= widgetData.filename, /verbose
       r= messageBox( ['I have restored ','spectrogram data from ', $
                       widgetData.filename], ['Thanks'], /center, $
                      title='File Status' )    
   endif else if strleft( uval,3 ) eq 'hfw' then begin
       widgetData= hydra_file_widget_event( event, widgetData )
   endif else BEGIN
       widgetData=PAPCO_panel_Event(event, widgetData)
   ENDELSE
END

   
;***************************************************************************
;***************************************************************************
;* 
;* FILE:
;*    $PAPCO_PATH/hydra_spec_panel.pro
;* 
;*    This file belongs to the PAPCO-project. See $PAPCO_PATH/papco.pro for
;*    further information.
;*
;* DESCRIPTION: 
;*    This file contains a demonstration on how to implement a PAPCO-
;*    panel-editor. It makes use of all the features provided by 
;*    $PAPCO_PATH/papco_panel.pro
;*    It constructs an editor for a very simple PAPCO-plot, that has only
;*    default-functionality.
;*
;* FILES YOU MAY WANT TO READ
;*       $PAPCO_PATH/papco_conventions.text     which conventions were used
;*						when developing ?
;*	 $PAPCO_PATH/papco_variables.text	what structures and global
;*						variables are used by 
;*						which file ?
;*
;* USED MODULES:
;*    For a list of files, that are needed for PAPCO to run, read the 
;*    file addpapco_init.PRO in $PAPCO_MODULES
;*
;* COMMON-BLOCKS:
;*    hydra_spec_panel_DATA	contains the window-information
;*
;* STRUCTURES:
;*    This module creates one concrete structure, that inherits from the 
;*    PAPCO_PANEL_EDITOR-structure (see $PAPCO_PATH/papco_panel.pro for a
;*    description). 
;*       {hydra_spec_panel_DATA, 
;*	     ; imagine the PAPCO_PANEL_EDITOR-structure was inserted...
;*	      
;*    For a more complete description see $PAPCO_PATH/papco_variables.text
;*
;* OVERVIEW:
;*    This function creates the editor-window:
;*       FUNCTION  hydra_spec_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;*    You might try this:
;*	 print, hydra_spec_panel(PAPCO_getPlotInfoStruct())
;*       which calls up the window.
;*
;* MODIFICATION HISTORY:       
;*     august 1995, written by A.Keese
;*     December 1995, modified by R.Friedel at Goddard
;*     
;***************************************************************************
;***************************************************************************

;***************************************************************************
;* 
;* FUNCTION:     
;*      FUNCTION  hydra_spec_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;* 
;* DESCRIPTION:  
;*	Open an editor for a panelplot.
;*	Its window is constructed using the methods defined in the file
;*	$PAPCO_PATH/papco_panel.pro
;*	When the user presses the 'Done'- or the 'Cancel'-Button, the values 
;*	changed by the event-methods of papco_panel.pro are returned.
;*	The returned value is a structure containing those values and a flag,	
;*	'canceled', which the caller may read out to check, whether the 
;*	window was closed using the 'Cancel' or the 'Done'-Button.
;*
;* INPUTS:       
;*	aPlotInfo	a structure of the PAPCO_PLOTINFO-type
;*			this structure is edited in the window.
;*     
;* KEYWORDS:
;* 	GROUP		a WIDGET_BASE
;*			when specified, this is used as GROUP_LEADER
;*	ACTION		a string
;*			when specified, the 'Done'-Button is labeled with it
;*		        if not specified, the 'Done'-Button is labeled 'Done'
;*
;* OUTPUT:	 
;*      a default-structure of type PAPCO_PANEL_EDITOR_RETURN. Though this
;*	type is nowhere defined, I like to think of it as virtually existing
;*	data-type. 
;*	All the functions in $PAPCO_PATH/papco.pro that edit plots or add new
;*	ones, expect the opened editor-windows to return a structure containing
;*	at last some fields. Those fields might make up a structure, but as no
;*	program defines the structure-type PAPCO_PANEL_EDITOR_RETURN, this 
;*	poor structure is not alive but only virtual.
;*	The return-values of plot-editors have to expand this structure - I 
;*	like to think, that they inherit from that structure - and contain at
;*	least those fields:
;*   		{$
;*			canceled:1, $
;*	    		panelHeight:1, $
;*	    		channel:0, $
;*	    		typeVector:[0,0,0,0], $ 
;*	    		manualYScaling:0 $
;*	    		yScaleMin:LONG(1), $
;*	    		yScaleMax:LONG(1), $
;*	    		panelKind:'some string'}
;*
;*      Additionally, some Panel-editors may return these fields in
;*      structure:
;*               {$
;*		        color:1, $
;*			plotStyle:1}
;*			
;*      For an enhanced description read $PAPCO_PATH/papco_variables.text
;*
;* CALLING SEQUENCE:
;*	aPlotInfoStruct=PAPCO_getPlotInfoStruct()
;*
;* MODIFICATION HISTORY:       
;*     written august 1995, Andreas Keese
;*
;***************************************************************************
FUNCTION  hydra_spec_panel, aPlotInfo, GROUP=group, ACTION=ACTION
   COMMON hydra_spec_panel_DATA, widgetData

; if GROUP is not specified, the group-leader will be the desktop
   IF NOT KEYWORD_SET(GROUP) THEN GROUP=0

; set the label for the action-button
   IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'

; the routines used by papco_panel.pro define tags for a structure. Those
; tags will be stored in the structure 'additionalWData'. When you realize the
; window, you have to add your own window-specific data to that structure 
; and afterwards assign it to widgetData.
   additionalWData={canceled:1}

;--- create the base-window --------------------------------------------------
   v= strtrim( string( hydra_code_version( /spec ), format='(f6.2)' ), 2 )
   panel_base=WIDGET_BASE(title=aPlotInfo.panelKind+' '+v,$
	 column=1, $
	 GROUP_LEADER=group)

;--- the first part of the window will consist in the widgets ----------------
;    that control the height of that plot
   widgets=PAPCO_panel_AddHeightWidgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

   base1= widget_base( panel_base, /row, /frame )
; --- Choose plot type------------------------------------------------------ 
   type_base=WIDGET_BASE(base1, COLUMN=1, /EXCLUSIVE, /frame ) 
   typeNames=['electrons', $
              'ions' ]
   spb_type=lonarr(N_ELEMENTS(typeNames))

   FOR i=0, N_ELEMENTS(typeNames)-1 DO $
      spb_type(i)=WIDGET_BUTTON(type_base, $
			VALUE=typeNames(i), $
			UVALUE='spb_type'+strtrim(string(i), 2))

   WIDGET_CONTROL, spb_type(aPlotInfo.typeVector(0)), SET_BUTTON=1

; --- Choose pitch angle range ------------------------
   type_base=WIDGET_BASE(base1, COLUMN=1, /EXCLUSIVE, /frame ) 
   typeNames=['all pitch angles', $
              'field aligned (pitch= 0-30 deg)', $
              'perpendicular (pitch= 75-105 deg)', $
              'field opposed (pitch= 150-180 deg)' ]

   spb_type=lonarr(N_ELEMENTS(typeNames))
   
   FOR i=0, N_ELEMENTS(typeNames)-1 DO $
     spb_type(i)=WIDGET_BUTTON(type_base, $
                               VALUE=typeNames(i), $
                               UVALUE='spb_pitch'+strtrim(string(i), 2) )
   
   WIDGET_CONTROL, spb_type(aPlotInfo.typeVector(2)), SET_BUTTON=1

; --- Choose spectrogram resolution -------------------
   base1= widget_base( panel_base, /row )
   type_base=WIDGET_BASE(base1, /column, /EXCLUSIVE, /frame ) 
   typenames=[ 'AutoSelect', $
               'Survey Resolution (13.8s)', $
               'Sweep Resolution (1.15s)' $
             ]   
   spb_type=lonarr(N_ELEMENTS(typeNames))
   
   FOR i=0, N_ELEMENTS(typeNames)-1 DO $
     spb_type(i)=WIDGET_BUTTON(type_base, $
                               VALUE=typeNames(i), $
                               UVALUE='spb_tres'+strtrim(string(i), 2))
   WIDGET_CONTROL, spb_type(aPlotInfo.typeVector(1)), SET_BUTTON=1
   
; --- Options ---
;   bit 1 is shift, bits 2,4 are units
   base2= widget_base( base1, /column, /frame, /nonexclusive )
   b= widget_button( base2, value='Shift By S/C Pot' )
   widget_control, b, $
     set_button= aPlotInfo.typeVector(3) and 1, $
     set_uvalue='spb_shift'+ strtrim( aPlotInfo.typeVector(3) and 1,2 )   
   base3= widget_base( base1, /column, /frame, /exclusive )
   b=lonarr(4)
   b(1)= widget_button( base3, value='counts',uvalue='spb_Zunits1' )
   b(0)= widget_button( base3, value='diff energy flux',uvalue='spb_Zunits0' )
   b(2)= widget_button( base3, value='diff number flux',uvalue='spb_Zunits2' )

   if not polar_hydra_public() then begin
       b(3)= widget_button( base3, value='density normalized',uvalue='spb_Zunits3')
   endif else begin
       if (( aPlotInfo.typeVector(3) and 14 )/2) gt 2 then begin
           message, 'Zunits=density normalized is not available on this system.', /cont
           aPlotInfo.typeVector(3)= aPlotInfo.typeVector(3) and (not long(14) )
       endif
   endelse
   widget_control, b(( aPlotInfo.typeVector(3) and 14 )/2 ), set_button= 1 

; --- saveset widgets ----
   widgets= hydra_File_Widget(panel_base, aPlotInfo, /create, /load, /save)
   additionalWData=create_struct(widgets, additionalWData)      
   
; --- Configure button -----------------
   type_base=WIDGET_BASE(panel_base, /FRAME, /row )

   spb= widget_button( type_base, $
                       value='Info', $
                       uvalue='spb_info' )
   
   if hydra_new_papco(vers=vers) and vers ge 9.0 then begin       
       spb= widget_button( type_base, $
                           value='L1 Options', $
                           uvalue='spb_l1_options' )
   endif
   
   spb= widget_button( type_base, $
                       value='Reload Data', $
                       uvalue='spb_reload' )
   
; ---add y range scaling widgets
   widgets= papco_panel_addYscale_widgets( panel_base, aPlotInfo )
   additionalWData=create_struct(widgets, additionalWData)   
                       
; ---add z range scaling widgets
   widgets=PAPCO_PANEL_AddZScale_Widgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;--- add the widgets for choosing the color bar for color plots
;                                ;----------------
   widgets=PAPCO_panel_AddColorBar_Widgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window.
   widgets=PAPCO_panel_AddActionButtons(panel_base, Action, aPlotInfo, /config)
   additionalWData=create_struct(widgets, additionalWData)

;--- now, create the structure that keeps the panel-window data. You
;    always need to specify the help-file, and your structure must
;    always contain the 'additionalWData'.
   thisWidgetsData={helpfile:'hydra_spec_panel.help', $
                    typevector:aPlotInfo.typeVector, $
                    options:aPlotInfo.options, $
                    soptions:aPlotInfo.soptions, $
                    spb_type:spb_type}

   widgetData=PAPCO_PANEL_CreateWidgetData(thisWidgetsData, additionalWData)

;--- realize the window
   PAPCO_Panel_Realize, panel_base, widgetData, yoffset=0, xoffset=300
   
; As this is a function that will return all changes made by the
; user, the xmanager has to be called with the keyword MODAL. If we
; wouldn't specify /MODAL, no changes would be reportet but the 
; data contained in aPlotInfo would be returned.
   xmanager, 'hydra_spec_panel', panel_base, /MODAL

; the returned data consists of the standard-data inherited from
; PAPCO_PANEL.PRO and your new data - e.g. the typeVector-tag.

   print, widgetData.soptions[0]
   returnData={typeVector:widgetData.typeVector, $
               options:widgetData.options, $
               soptions:widgetData.soptions }
       
   additionalRData=PAPCO_panel_ReturnData(widgetData)

   return, create_struct(ReturnData, additionalRData)
END











