pro hydra_walen_killed, id
COMMON WALEN_HYDRA_DRAWSLICE, sliceWidgetData
r= temporary( sliceWidgetData )
end

pro walen_tool_event, event

widget_control, event.id, get_uvalue=uval
child= widget_info( event.top, /child )
widget_control, child, get_uvalue=state
case uval of 
    'Control': begin
        if not widget_info( state.control_base, /valid_id ) then begin
            
; Set the base widget ID for the control panel extension
            b= widget_base( state.control_parent, /row )
            state.control_base= b
            
; 1st Column of choices - Zoom of the Walen test
            b1= widget_base( b, /column )
            x= cw_field( b1, title='zoom (0,1,2...): ', $
                           /integer, value=state.zoom, uval='zoom', /return_ev)
            
; 2nd Column of choices - Method for differencing Walen
            b1= widget_base( b, /column, /exclusive)
            values = ['Mid-referenced',$
                      'Asymptotic']
            x = lonarr(n_elements(values))
            for i=0,n_elements(values)-1 do begin
                x(i)= widget_button( b1, value=values(i), $
                                     uval='diff'+strtrim(string(i),2) ,/no_release )
            endfor
            widget_control, x(state.diff_method), set_button = 1
            
        endif else begin
            widget_control, state.control_base, /destroy
        endelse
    end
    'Draw': walen_tool
    'zoom': begin
        state.zoom = event.value
        redraw=1
    end
    'diff0': begin
        state.diff_method = 0
        redraw=1
    end
    'diff1': begin
        state.diff_method = 1
        redraw=1
    end
    'Print': walen_tool, /hc
    'Close': begin
        widget_control, event.top, /destroy
        return
    end
    'Help': begin
        xdisplayfile, papco_helpfile('walen_tool.help'), $
          title='papco Online-Help', group=event.top      
    end
    else: begin
        message, 'uval not recognised: '+uval, /cont
    end
end      
widget_control, child, set_uvalue=state
if keyword_set( redraw ) then walen_tool

return
end

PRO walen_tool, datestr_in, starttime_in, stoptime_in, hc=hc

common walen_data, datestr, starttime, stoptime, $
  diff_method, zoom, wdata, inds, ref_index, wfit

common get_error, get_err_no, get_err_msg

; datestr_in = 'YYYYMMDD'
; starttime_in in seconds since midnight
; stoptime_in in seconds since midnight

COMMON WALEN_HYDRA_DRAWSLICE, sliceWidgetData

myname='WALEN_TOOL: '

return
hc= keyword_set( hc )

if n_elements( datestr_in ) eq 0 then begin ; we've reentered this code
    datestr_in = sliceWidgetData.datestr
    starttime_in = sliceWidgetData.starttime
    stoptime_in = sliceWidgetData.stoptime
endif

datestr = datestr_in
starttime = starttime_in
stoptime = stoptime_in

if hc then begin
    set_plot, 'ps'
    filename='walen_tool.ps'
    device, filename=filename, xsize=7.5, ysize=7,/inches, /color, /landscape
    build_widget=0 
endif else begin
;      create widget if it doesn't exist already.
    if n_elements( sliceWidgetData ) gt 0 then begin
        if Widget_Info( sliceWidgetData.base, /Valid_ID)  eq 0 then begin
            build_widget=1
        endif else begin
            build_widget=0
        endelse
    endif else begin
        build_widget=1
    endelse
    
    if build_widget then begin
        b= widget_base( title='hydra_walen_tool', /col )
        child= widget_base( b ) 
        state= { control_parent:0L, $
                 control_base:0L, $
                 zoom:0L , $
                 diff_method:0 }         
        d= widget_draw( b, xsize=800, ysize=700 )
        b1= widget_base( b, /row )
        bu= widget_button( b1, value='Control', uvalue='Control' )
        bu= widget_button( b1, value='Help', uvalue='Help' )
        bu= widget_button( b1, value='Print', uvalue='Print' )
        bu= widget_button( b1, value='Close', uvalue='Close' )
        state.control_parent= widget_base(b) 
        widget_control, b, /realize
        widget_control, d, get_value=winidx
        sliceWidgetData= { base:b, $
                           winidx:winidx, $
                           datestr:datestr, $
                           starttime:starttime, $
                           stoptime:stoptime}
        xmanager, 'walen_tool', b, cleanup='hydra_walen_killed'
        widget_control, child, set_uvalue=state
    endif else begin
        wset, sliceWidgetData.winidx
    endelse
endelse

child= widget_info( sliceWidgetData.base, /child )
widget_control, child, get_uvalue=state
diff_method = state.diff_method
zoom = state.zoom
get_err_no = 0
get_err_mgs = myname+'Success'

if ( build_widget or $
     (datestr ne sliceWidgetData.datestr) or $
     (starttime ne sliceWidgetData.starttime) or $
     (stoptime ne sliceWidgetData.stoptime) ) then begin
    
    widget_control,/hourglass
    
; Temporary plot while waiting...
    erase, get_color_index('white')
    !p.position=0
    !p.noerase=0
    !p.background = get_color_index('white')
    !p.multi = [0,1,1]
    black= get_color_index('black')
    plot, findgen(5), findgen(5), title='Walen Tool', $
      /nodata, color=black, xticks=0, xstyle=4, ystyle=4
    xyouts, .5, .5, 'READING IN THE DATA...', /normal, color=black, $
      alignment=.5, charsize=2.0
    
; Read in the data
    r_hydra_walen
    sliceWidgetData.datestr= datestr
    sliceWidgetData.starttime= starttime
    sliceWidgetData.stoptime= stoptime
    if (get_err_no eq 2) then begin
        goto, error_plot
    endif
endif

; How many moments measurments do we have to deal with?
nmom = n_elements(wdata.time)

;print, 'nmom: ', nmom
;print, 'zoom: ', zoom
;print, 'diff_method: ', diff_method

if (nmom lt 2) then begin
    get_err_no = 2
    get_err_msg = myname+'Selection too small...Need at least two points...'
    goto, error_plot
endif else if (nmom eq 2) then begin
    diff_method = 1             ; Asymptotic only, Mid-ref not possible
    inds = lindgen(nmom)
;    print, 'nmom=2, inds: ', inds
endif else begin
;      Select which indicies to use based on the value of zoom
    ninds = nmom - long(2.*zoom)
    if (ninds lt 2) then begin
        get_err_no = 2
        get_err_msg = myname+'Zoom too large...Need at least two points...'
        goto, error_plot
    endif else if (ninds eq 2) then begin
        diff_method = 1         ; Asymptotic only, Mid-ref not possible
        inds = lindgen(ninds) + zoom
;        print, 'ninds=2, inds: ', inds
    endif else begin
        ref_index = long(nmom/2.)
        inds = lindgen(ninds) + zoom
;        print, 'valid, inds: ', inds
;        print, 'ref_index: ', ref_index
    endelse
endelse

erase, get_color_index('white')
!p.position=0
!p.noerase=0
!p.background = get_color_index('white')
!p.multi = [0,2,2,0,1]
black= get_color_index('black')

; Electon plots - MUST BE CALLED BEFORE IONS! (SETS RANGE)
perform_hydra_walen
if (get_err_no eq 2) then begin
    for iplot=0,1 do begin
        plot, findgen(5), findgen(5), /nodata, color=black, $
          xticks=0, xstyle=4, ystyle=4, title='Ele'
        outs = norm_axis([.5,.5])
        xyouts, outs(0), outs(1), get_err_msg, color=black, $
          alignment=.5, charsize=1.0
    endfor
endif else begin
    p_hydra_walen, hc=hc
endelse

; Ion plots
perform_hydra_walen, /ion
if (get_err_no eq 2) then begin
    for iplot=0,1 do begin
        plot, findgen(5), findgen(5), /nodata, color=black, $
          xticks=0, xstyle=4, ystyle=4, title='Ion'
        outs = norm_axis([.5,.5])
        xyouts, outs(0), outs(1), get_err_msg, color=black, $
          alignment=.5, charsize=1.0
    endfor
endif else begin
    p_hydra_walen, hc=hc
endelse

goto, skip_error_plot

error_plot:                     ; =================================
erase, get_color_index('white')
!p.position=0
!p.noerase=0
!p.background = get_color_index('white')
!p.multi = [0,1,1]
black= get_color_index('black')

plot, findgen(5), findgen(5), title='Walen Tool', /nodata, color=black, xticks=0, xstyle=4, ystyle=4

xyouts, .5, .5, get_err_msg, /normal, color=black, alignment=.5, charsize=2.0

skip_error_plot:


if hc then begin
    device, /close
    r= widget_message( ['Created ',filename], /info )
    set_plot, 'x'
endif
return

END




