PRO correct_bfield, phib, thetab, bmag, bvalid, rec_start, rec_count, CDF, $
                    nocorrect=nocorrect, highres=highres, cdfcal=CAL


   i4fill = long(-2147483648)
   i2fill = -32768
   rfill = -1.0e-31

   phib= ( phib + 0.5 ) * (2 * !pi / 256.)
   thetab= (thetab + 0.5 ) * (2 * !pi / 256.)

   bmag= make_array( 384, rec_count, /float )

   rhyd= indgen(384)*2+1 ; these are the indeces of measurements that are used.

   bvalid = make_array( size=size(phib), /byte, value=1 )

   hyd_cdf_varget, CDF, 'BLOCK_TIME', rectimes, $
     rec_start=rec_start, rec_count=rec_count
   rectimes= reform( rectimes )
   
   cdf_epoch, mfefixx, 96, 4, 2, 17, 30, /compute 
   
   rflipx= where( rectimes lt mfefixx )
   if rflipx(0) ne -1 then begin
       phib(*,rflipx) = !pi-phib(*,rflipx)
       print, 'phib: x-axis value flipped.'
   ENDIF 

   IF keyword_set(nocorrect) THEN return

   print, 'Correcting B-angles.'

   hyd_cdf_varget, CDF, 'PHASE_START', phase_start, $
     rec_start=rec_start, rec_count=rec_count
   phase_start= reform( rebin( phase_start(*), 384*rec_count ), $
                        384, rec_count )

   hyd_cdf_varget, CDF, 'BLOCK_MODE', block_mode, $
     rec_start=rec_start, rec_count=rec_count

   if block_mode(0) ne block_mode(n_elements(block_mode)-1) then $
     message, 'Warning: Block modes change, but phi_offset assumed constant.'
   
   block_mode=block_mode(0)
   
   hyd_cdf_varget, CDF, 'PHI_OFFSET', phi_offset, $
     rec_start=block_mode-1
   phi_offset= phi_offset # make_array( rec_count, value=1 ) 
;   

;  B_AVG_RAW is three raw 16-bit components of B from SCR
   hyd_cdf_varget, CDF, 'B_AVG_RAW', b_avg_raw, $
     rec_start=rec_start, rec_count= rec_count

; MFE_STATUS bits: 1=OFF/ON, 2=Inb/Out Sensor, 4=Low/High Range,
;                  8=Left/Right Flipper
;         15 = 1+2+4+8 = On, Out, High, Right

   hyd_cdf_varget, CDF, 'MFE_STATUS', mfe_status, $
     rec_start=rec_start, rec_count= rec_count

   rstat = where( ((mfe_status and 1) eq 0) or (b_avg_raw(0,*) EQ i2fill) )
   if (rstat(0) ne -1) then begin
       print, "Fill data found for B, no correction possible."
       bvalid(*,rstat) = 0
   endif
   rokay = where( ((mfe_status and 1) eq 1) and (b_avg_raw(0,*) NE i2fill) )
   if (rokay(0) eq -1) then return

   flipper_index = (mfe_status AND 8) eq  8
   range_index = (mfe_status AND 4) eq 4 
   sensor_index = (mfe_status AND 2) eq 2

;  mfe_offset_flag = 1 -> offsets in nT
;  mfe_offset_flag = 2 -> offsets in Counts
;
   hyd_cdf_varget, CDF, 'MFE_OFFSET_FLAG', mfe_offset_flag

;  mfe_gains: indexed by (x/y/z, Inb/Out, Low/High, Left/Right) in nT/Count
;
;
   hyd_cdf_varget, CDF, 'MFE_GAINS', mfe_gains
       
;  mfe_offset: indexed by (x/y/z, Inb/Out, Low/High, itime) in nT
;
;
   hyd_cdf_varget, CDF, 'MFE_OFFSET', mfe_offset
   hyd_cdf_varget, CDF, 'MFE_OFFSET_RAW', mfe_offset_raw
   
   hyd_cdf_varget, CDF, 'MFE_OFFSET_START', mfe_offset_start
   hyd_cdf_varget, CDF, 'MFE_OFFSET_END', mfe_offset_end
   
;  mfe_matrix: indexed by (x/y/z, x/y/z, Inb/Out, Low/High) in nT/Count
;
;
   hyd_cdf_varget, CDF, 'MFE_MATRIX', mfe_matrix

;  use high resolution 3D (x,y,z) mfe data
   highres=0   
   cdf_control, CDF, var='B_HIGH_RAW', get_var_info=r 

   if n_elements( r ) gt 0 then $
     if r.maxrec gt -1 then begin
       highres=1
       print, '## Using high-res B-field magnitude data...'
       get_hr_bmag, CDF, rec_start, rec_count, bmaghr, t, /hydtim
       bmaghr= reform( bmaghr, 384, rec_count )
   endif

   print, format='(a,$)', 'A'

; break cdf epoch into h,m,s
   hr= long( rectimes mod 86400000 / 3600000. )
   mn= long( rectimes mod  3600000 /   60000. )
   sc= long( rectimes mod    60000 /    1000. )
   time= hr*10000L + mn*100L + sc ; HHMMSS

   idmode= sensor_index(*)*2 + range_index*6 + flipper_index*12
   u=uniq( idmode )
   n=n_elements(u)-1
   mode_start= ([0,u+1])(0:n)
   mode_count= u-mode_start+1

;  fill itime index   
   itime= lonarr( n_elements( idmode ) )
   for imode= 0, n_elements(u)-1 do begin
       i= mode_start(imode)
       rmode= mode_start(imode)+indgen(mode_count(imode))
       mfe_time_start = $
         reform( mfe_offset_start(sensor_index(i),range_index(i),*) )
       mfe_time_end = $
         reform( mfe_offset_end(sensor_index(i),range_index(i),*) )

       time1= time(rmode)

       itime(rmode)= $
         ( time1 gt mfe_time_start(0) and time1 le mfe_time_end(0) ) * 1 + $
         ( time1 gt mfe_time_start(1) and time1 le mfe_time_end(1) ) * 2 + $
         ( time1 gt mfe_time_start(2) and time1 le mfe_time_end(2) ) * 3 + $
         ( time1 gt mfe_time_start(3) and time1 le mfe_time_end(3) ) * 4 
   
       r= where( itime(rmode) eq 0, count )       
       if count gt 0 then begin
;           message, 'MFE B Correction failed to get offset', /cont
           bvalid(*,rmode(r))=0
       endif
   endfor

   print, format='(a,$)', 'B'


   
;  now find uniq modes also considering offsets
   idmode= sensor_index(*)*2 + range_index*6 + flipper_index*12 + itime*24
   u=uniq( idmode )
   n=n_elements(u)-1
   mode_start= ([0,u+1])(0:n)
   mode_count= u-mode_start+1

   for imode= 0, n_elements(u)-1 do begin
       in= mode_start(imode)
       out= mode_start(imode)+mode_count(imode)-1 ; a(in:out) convention
       
       gains= mfe_gains(*,sensor_index(in),range_index(in),flipper_index(in))
       matrix= mfe_matrix(*,*,sensor_index(in),range_index(in))
       
       offset= mfe_offset(*,sensor_index(in),range_index(in),itime(in))
       offset_raw= mfe_offset_raw(*,sensor_index(in),range_index(in),itime(in))

       if not keyword_set( highres ) then begin
           bavg_rawi = long(b_avg_raw(*,in:out))
           bmag_raw = sqrt(total(bavg_rawi*bavg_rawi,1))
           bmag_raw = make_array( 384, value=1, /int ) # bmag_raw ; 

           cosphi = cos(phib(rhyd,in:out))
           sinphi = sin(phib(rhyd,in:out))
           
           costheta = cos(thetab(rhyd,in:out))
           sintheta = sin(thetab(rhyd,in:out))
           
           bx0 = (sintheta*cosphi*bmag_raw)
           by0 = (sintheta*sinphi*bmag_raw)
           bz0 = (costheta*bmag_raw)
       
       endif else begin
           cosphi = cos(phib(rhyd,in:out))
           sinphi = sin(phib(rhyd,in:out))
       
           costheta = cos(thetab(rhyd,in:out))
           sintheta = sin(thetab(rhyd,in:out))

           bmaghr1= bmaghr(*,in:out)
           bx0 = (sintheta*cosphi*bmaghr1)
           by0 = (sintheta*sinphi*bmaghr1)
           bz0 = (costheta*bmaghr1)
       endelse                  

       IF (mfe_offset_flag EQ 1) THEN BEGIN 
           
           bx1 = bx0*gains(0) - offset(0)
           by1 = by0*gains(1) - offset(1)
           bz1 = bz0*gains(2) - offset(2)
           
;           b_avg_raw1 = reform( [ b_avg_raw(0,in:out)*gains(0) - offset(0), $
;                                  b_avg_raw(1,in:out)*gains(1) - offset(1), $
;                                  b_avg_raw(2,in:out)*gains(2) - offset(2) ], $
;                                mode_count(imode), 3 )           

       ENDIF ELSE BEGIN 
           
           bx1 = (bx0-offset_raw(0))*gains(0) - offset(0)
           by1 = (by0-offset_raw(1))*gains(1) - offset(1)
           bz1 = (bz0-offset_raw(2))*gains(2) - offset(2)
           
;           b_avg_raw1 = $
;             reform( [ (b_avg_raw(0,in:out)-offset_raw(0))*gains(0) - offset(0), $
;                       (b_avg_raw(1,in:out)-offset_raw(1))*gains(1) - offset(1), $
;                       (b_avg_raw(2,in:out)-offset_raw(2))*gains(2) - offset(2) ], $
;                     mode_count(imode), 3 )
           
       ENDELSE 

       bx2 = bx1*matrix(0,0) + by1*matrix(0,1) + bz1*matrix(0,2)
       by2 = bx1*matrix(1,0) + by1*matrix(1,1) + bz1*matrix(1,2)
       bz2 = bx1*matrix(2,0) + by1*matrix(2,1) + bz1*matrix(2,2)
       
;       b_avg_raw2= fltarr(3,mode_count(imode))
;       b_avg_raw1= transpose( b_avg_raw1 )
;       b_avg_raw2(0,*) = b_avg_raw1##matrix(0,*)
;       b_avg_raw2(1,*) = b_avg_raw1##matrix(1,*)
;       b_avg_raw2(2,*) = b_avg_raw1##matrix(2,*)
;
;       b_avg = b_avg_raw2
;  jbf optimization: above results not used, so I comment it out.       
       
       sc_phase= phase_start(*,in:out) + phi_offset(*,in:out) - 5.9*!dtor
       bx3= bx2*cos(sc_phase)-by2*sin(sc_phase)
       by3= bx2*sin(sc_phase)+by2*cos(sc_phase)
;       bz3= bz2
       
       bmag1 = sqrt(bx3^2 +by3^2+bz2^2)
       bhatx = bx3/bmag1
       bhaty = by3/bmag1
       bhatz = bz2/bmag1
       
       bmag(*,in:out) = bmag1
       thetab1= acos(bhatz)
       thetab(rhyd,in:out) = thetab1
       thetab(rhyd-1,in:out) = thetab1
       
       phib1= acos( ( bhatx/sin(temporary(thetab1))) < 1.0 > (-1.0) )
       r = where(bhaty LT 0.)
       if r(0) ne -1 then phib1(r)= 2*!pi - phib1(r)
       
       phib(rhyd,in:out) = phib1
       phib(rhyd-1,in:out) = phib1
       
   endfor    

   phib= byte( phib / (2 * !pi / 256.) )
   thetab= byte( thetab / (2 * !pi / 256.) )

END



