pro spectra_l1_average, counts1, datamask, subblocks, $ ; input
                        sigma_counts= d_counts1_in, $ ; input
                        initialize=init, $ ; initialize mode
                        energy_index=energy_index, energy_seq=energy_seq, $
                        split=split_in, $ ; in 
                        intdata= intdata_out, $ ; out from init mode
                        spec_out, sigma_spec_out=sigma_out ; output

    common spectra_l1_average_common, $
      idx_en0, idx_en1, $
      evendet, odddet, $
      S24odd, N24odd, dS24odd, $ ; I put these in common blocks so they are 
      S24even, N24even, dS24even, $ ; not allocated each invokation
      S1, N1, dS1, $
      Sint, Nint, dSint, $
      intdata, nsum, $
      split, nen
    
    if keyword_set(init) then begin
        
        nen= max( abs( energy_index(*,0 ) ) ) * 2 + 1
        
        intdata= { $
                   energy_interp:fltarr(nen), $
                   energy_box:fltarr(nen,2), $
                   i1:intarr(nen,2), $ ; indeces used for interpolation
                   i2:intarr(nen,2), $
                   ii1:intarr(nen,2), $ ; fall-back indeces (further away)
                   ii2:intarr(nen,2), $
                   a1:fltarr(nen,2), $
                   a2:fltarr(nen,2) $
                 }
        
        rval= where( energy_index(*,0) ne 0 )
        min0=min( abs( energy_seq(rval,0) ), max=max0 )
        min1=min( abs( energy_seq(rval,1) ), max=max1 )
        mine= alog10(max([min0,min1]))
        maxe= alog10(min([max0,max1]))
        
        nspec= nen/2
        rele= indgen(nspec)
        rion= indgen(nspec)+nspec+1

        intdata.energy_interp( rele ) = $
          mine + ( 1. - findgen(nspec)/(nspec-1) ) * ( maxe-mine )
        intdata.energy_interp( rion ) = $
          mine + findgen(nspec)/(nspec-1) * ( maxe-mine )
        
        split= keyword_set( split_in )

        if not split then begin
            for ibox=0,1 do begin

                r= where( energy_index(*,0) ne 0 )
                intdata.energy_box( energy_index(r,0)+nspec, ibox ) = $
                  alog10(abs(energy_seq(r,ibox)))
                
                re= interpol( rele, intdata.energy_box(rele,ibox), $
                              intdata.energy_interp(rele) )
                ri= interpol( rion, intdata.energy_box(rion,ibox), $
                              intdata.energy_interp(rion) )
           
                r= [ re, 0, ri ]

                rd= r-1 > 0
                ru= r+1 < (nen-1)

                intdata.i1(*,ibox)= floor( r )
                intdata.i2(*,ibox)= intdata.i1(*,ibox) + 1
                intdata.a1(*,ibox)= intdata.i2(*,ibox) - r
                intdata.a2(*,ibox)= 1 - intdata.a1(*,ibox)
                intdata.ii1(rele,ibox)= ( intdata.i1(rele,ibox) - 1 ) > 0
                intdata.ii1(rion,ibox)= ( intdata.i1(rele,ibox) - 1 ) > nspec+1
                intdata.ii2(rele,ibox)= ( intdata.i2(rion,ibox) + 1 ) < ( nspec-1 )
                intdata.ii2(rion,ibox)= ( intdata.i2(rion,ibox) + 1 ) < ( nen-1 )
            endfor 
            intdata= [ intdata, intdata ]

        endif else begin
            intdata= [ intdata, intdata ] ; for 1x2x mode, two intdata 
            intdata(*).energy_box(*)= 0.0
            
            for isub=0,1 do begin
                rsub= indgen( 384/2 ) + isub*(384/2)
                for ibox=0,1 do begin
                    intdata(isub). $
                      energy_box( energy_index(rsub,ibox)+nspec,ibox ) = $
                      alog10(abs(energy_seq(rsub,ibox)))
                    
                    rv= where( intdata(isub).energy_box( rele, ibox ) ne 0.0, c)
                    r= interpol( indgen(c), $
                                 intdata(isub).energy_box(rele(rv), ibox),$
                                 intdata(isub).energy_interp(rele) )
                    
                    intdata(isub).i1(rele,ibox)= rele( rv( floor( r ) ) )
                    intdata(isub).i2(rele,ibox)= rele( rv( floor( r )+1 ) )
                    intdata(isub).a2(rele,ibox)= r - floor(r) 
                    intdata(isub).a1(rele,ibox)= 1 -intdata(isub).a2(rele,ibox)
                    intdata(isub).ii1(rele,ibox)= rele( rv( floor( (r-1)>0 ) ) )
                    intdata(isub).ii2(rele,ibox)= rele( rv( floor( (r+1)<(c-1) )+1 ) )

                    rv= where( intdata(isub).energy_box( rion,ibox ) ne 0.0, c)
                    
                    r= interpol( indgen(c), $
                                 intdata(isub).energy_box(rion(rv),ibox), $
                                 intdata(isub).energy_interp(rion) )
                    
                    intdata(isub).i1(rion,ibox)= rion( rv( floor( r ) ) )
                    intdata(isub).i2(rion,ibox)= rion( rv( floor( r )+1 ) )
                    intdata(isub).a2(rion,ibox)= r - floor(r) 
                    intdata(isub).a1(rion,ibox)= 1 -intdata(isub).a2(rion,ibox)
                    intdata(isub).ii1(rion,ibox)= rion( rv( floor( (r-1)>0 ) ) )
                    intdata(isub).ii2(rion,ibox)= rion( rv( floor( (r+1)<(c-1) )+1 ))
                    intdata(isub).i1(nspec,ibox)= nspec
                    intdata(isub).i2(nspec,ibox)= nspec
                    intdata(isub).ii1(nspec,ibox)= nspec
                    intdata(isub).ii2(nspec,ibox)= nspec
                    
                endfor          ; ibox
            endfor              ; isub

        endelse
                  
        intdata_out= intdata

;        new averaging scheme:  
;          total over box, then 
;          resort to sweepwise energy-ordered arrays, then
;          total sweepwise energy-ordered arrays.

        isub= rebin( indgen(24), 384 ) * nen
        
        ien0= energy_index(*,0)+nspec
        ien1= energy_index(*,1)+nspec
        
        idx_en0= ien0+isub      ; indexes energy-ordered array
        idx_en1= ien1+isub

        idet= indgen( 12 )
        
        evendet= where( idet mod 2 )
        odddet= where( (idet+1) mod 2 )
        
;      define blank sub24 arrays
        
        S24odd= fltarr( nen, 24 )
        N24odd= intarr( nen, 24 )
        S24even= fltarr( nen, 24 )
        N24even= intarr( nen, 24 )

        dS24odd= fltarr( nen, 24 ) ; for sigmas
        dS24even= fltarr( nen, 24 )
        
        S1= fltarr( nen, 2 )
        N1= intarr( nen, 2 )
        dS1= fltarr( nen, 2 )

        Sint= fltarr( nen,2 )
        Nint= fltarr( nen,2 )
        dSint= fltarr( nen,2 )

        return
    endif

    nsum= 24/subblocks * 12     ; 12 detectors per subblock

    sigmas= n_elements( d_counts1_in ) gt 0
    if sigmas then begin
        d_counts2= d_counts1_in ^ 2.0
        sigma_out= fltarr( nen, subblocks )
    endif

;  sort to energy-ordered array 
    m= datamask
    mcounts1= counts1*m

    Seven= total( mcounts1( *, evendet ), 2 )
    Neven= total( m( *, evendet ), 2 )

    Sodd= total( mcounts1( *, odddet ), 2 )
    Nodd= total( m( *, odddet ), 2 )
    
    if sigmas then begin
        dSeven= total( d_counts2( *, evendet ), 2 )
        dSodd= total( d_counts2( *, odddet ), 2 )
    endif

    j= 6/subblocks > 1
    i= 384/j
    ri= lindgen(i)
    
    Seven1= total( reform( Seven, i, j ), 2 )
    Neven1= total( reform( Neven, i, j ), 2 )

    Sodd1= total( reform( Sodd, i, j ), 2 )
    Nodd1= total( reform( Nodd, i, j ), 2 )

    S24odd( idx_en0(ri) ) = Sodd1
    N24odd( idx_en0(ri) ) = Nodd1
    S24even( idx_en1(ri) ) = Seven1
    N24even( idx_en1(ri) ) = Neven1

    if sigmas then begin
        dSeven1= total( reform( dSeven, i, j ), 2 )
        dSodd1= total( reform( dSodd, i, j ), 2 )
        dS24even( idx_en1(ri) ) = dSeven1
        dS24odd( idx_en1(ri) ) = dSodd1
    endif

    spec_out= fltarr( nen, subblocks )    
    
    for iisub= 0, subblocks-1 do begin
        S1(*,0)= S24odd(*,iisub)
        N1(*,0)= N24odd(*,iisub)
        S1(*,1)= S24even(*,iisub)
        N1(*,1)= N24even(*,iisub)
        if sigmas then begin
            dS1(*,0)= dS24odd(*,iisub) 
            dS1(*,1)= dS24even(*,iisub)
        endif
        
        r= where( N1 gt 0 )
        if r(0) ne -1 then begin
            S1(r)= S1(r)/N1(r)
            if sigmas then dS1(r)= dS1(r) / N1(r)^2.
        endif

;      bring the boxes together
;      interpolate each box to common grid.           
        ihalf= fix( (iisub+0.5) / subblocks + 0.5 ) ; which half of the block

        for ibox=0,1 do begin
            i1= intdata(ihalf).i1(*,ibox)
            i2= intdata(ihalf).i2(*,ibox)

            rnv= where( N1(i1,ibox) eq 0 ) ; check for no data points
            if rnv(0) ne -1 then i1(rnv)= intdata(ihalf).ii1(rnv,ibox)
            rnv= where( N1(i2,ibox) eq 0 )
            if rnv(0) ne -1 then i2(rnv)= intdata(ihalf).ii2(rnv,ibox)
            
            den= intdata(ihalf).energy_box(i2,ibox) - $
              intdata(ihalf).energy_box(i1,ibox)

            r1= where( den ne 0 )
            r0= where( den eq 0 )

            a1= make_array( size= size( den ))
            a2= make_array( size= size( den ))
            
            if r1(0) ne -1 then begin
                a2(r1)= ( intdata(ihalf).energy_interp(r1) - $
                          intdata(ihalf).energy_box(i1(r1),ibox) ) / den(r1)
                a1(r1)= ( intdata(ihalf).energy_box(i2(r1),ibox) - $
                          intdata(ihalf).energy_interp(r1) ) / den(r1)
            endif

            if r0(0) ne -1 then begin ; same point....
                a1(r0)= 1.0
                a2(r0)= 0.0
;  better to rename one of the indeces I think...
            endif

;            r= check_math(1)
;            if r ne 0 then print, 'check_math()='+strtrim(r,2)
            
            Sint(*,ibox)= S1( i1,ibox ) * a1 + S1( i2,ibox ) * a2
            Nint(*,ibox)= N1( i1,ibox ) * a1 + N1( i2,ibox ) * a2

            if sigmas then dSint(*,ibox)= $
              dS1( i1,ibox ) * a1^2 +  dS1( i2,ibox ) * a2^2
        endfor

        rn= where( Nint(*) lt 1.0 )
        if rn(0) ne -1 then Nint(rn)= 0.0 ; <1.0 indicates one bracket was nv
        
        r= where( Nint(*,0) ge 1.0 or Nint(*,1) ge 1.0 ) 
        rn= where( Nint(*,0) eq 0.0 and Nint(*,1) eq 0.0 )
        if r(0) ne -1 then begin
            if sigmas then begin
                alph1= Nint(r,0) / (Nint(r,0)+Nint(r,1))
                alph2= Nint(r,1) / (Nint(r,0)+Nint(r,1))
                spec_out(r,iisub)= $
                  Sint(r,0)*alph1 + Sint(r,1)*alph2
                sigma_out(r,iisub)= $
                  dSint(r,0)*alph1^2 + dSint(r,1)*alph2^2
            endif else begin
                spec_out(r,iisub)= $
                  ( (Sint(r,0)*Nint(r,0)) + (Sint(r,1)*Nint(r,1)) ) / $
                  (Nint(r,0)+Nint(r,1))
            endelse
        endif
        if rn(0) ne -1 then spec_out(rn,iisub)= 1e-20
    endfor                      ; iisub           
    
    return
end
