PRO calc_hydra_baverage, date, time_ssst, time_ssm, bavg, bavg_sig, bavg_angle_cone, bavg_status
   
   common hydra_bfield_data, $
    bfield_type, $
    bfield_header, $
    bfield_lr_data, $
    bfield_mr_data, $
    bfield_hr_data, $
    bfield_ppar_data
   
   rfill = -1.e+31
   
   myname = 'calc_hydra_baverage'

; Open the ddcal file, check whether or not the MFE average is there
   
   f= hydra_findfile( date, /ddcal )
   if (f NE '') then begin
      print, myname+': opening '+f+'...'
      cdfcal = cdf_open(f)
   endif else begin
      stop                      ;hydra_findfile sets the error message
   ENDELSE
   
   isthere = cdf_varexist(cdfcal,'MFE_B_AVG')
   
   IF (isthere) THEN BEGIN
      
      print, myname+': Getting MFE baverage from the L1 ddcal file'

      load_mfe_bavg, cdfcal, time_ssm, bavg, bavg_sig, bavg_angle_cone, bavg_status
      
      cdf_close, cdfcal
      
   ENDIF ELSE BEGIN

      print, myname+': Calculating the MFE baverage on the fly'

      cdf_close, cdfcal
      
; Generate 8Hz magnetic field data for this time period
      bfield_type = 1
      r_hydra_bfield, options=7
      
; Define the magnetic field to be used below  
      bvalid = bfield_mr_data.bvalid*(bfield_mr_data.bflags EQ 0)
      gd = where(bvalid EQ 1)
      t = bfield_mr_data(gd).time ; This time is in seconds since start_time
      bx = bfield_mr_data(gd).bx_pay
      by = bfield_mr_data(gd).by_pay
      bz = bfield_mr_data(gd).bz_pay
      
      ntime = n_elements(time_ssst)
      bavg = fltarr(3,ntime)
      bavg_sig = fltarr(3,ntime)
      bavg_angle_cone = fltarr(ntime)
      bavg_status = intarr(ntime)
      
      FOR itime=0L,ntime-1 DO BEGIN
         
         istart = (where(t GE time_ssst(itime)))(0)
         istop =  (where(t GE time_ssst(itime) + 13.8))(0)
         
         IF (istart EQ -1 OR istop EQ -1 OR istart EQ istop) THEN BEGIN
            
            bavg(*,itime) = rfill
            bavg_sig(*,itime) = rfill
            bavg_angle_cone(itime) = rfill
            bavg_status(itime) = 0
            
         ENDIF ELSE BEGIN
            
            bcount = long(istop-istart+1)
            bsamp = dblarr(3,bcount)
            
; B samples for this 'block'
            bsamp(0,*) = bx(istart:istop)
            bsamp(1,*) = by(istart:istop)
            bsamp(2,*) = bz(istart:istop)
            
; Find the block average and sigma for the magnetic field
            
            bxstats = moment(bsamp(0,*))
            bystats = moment(bsamp(1,*))
            bzstats = moment(bsamp(2,*))
            
            bavg(0,itime) = bxstats(0) ;mean
            bavg(1,itime) = bystats(0) ;mean
            bavg(2,itime) = bzstats(0) ;mean
            bavg_mod = sqrt(total(bavg(*,itime)^2))
            
            bavg_sig(0,itime) = sqrt(bxstats(1)) ;sig=sqrt(var)
            bavg_sig(1,itime) = sqrt(bystats(1)) ;sig=sqrt(var)
            bavg_sig(2,itime) = sqrt(bzstats(1)) ;sig=sqrt(var)
            
            bavg_angle_cone(itime)=atan( $
                                        sqrt(bxstats(1)+bystats(1)+bzstats(1)) $
                                        / bavg_mod )
            
            bavg_status(itime) = 1
            
         ENDELSE
         
      ENDFOR
   
   ENDELSE

   return
END
