function callformat_example, index, x, _extra=e
; The call format procedure is intended to provide a way to interface
; existing routines to the thumb_plot code. 

; The idea is given the plot index (identifies plot) and the x
; ordinate, generate a string to call your procedure.  In this example,
; a routine called hydra_colorplot is to be called, and it prints as its title
; the index number.  So, 
;    (index,x) --> [ callformat_example ] --> "hydra_colorplot, title='1', ..."
;
; Alternatively, this routine can do the plot and return '' so that no
; additional plotting is done.
;
; _extra=e is intended to allow future expansion of the 
; thumb_plot code without breaking existing callformat interfaces.  
; In the future this code may receive
; keywords like "/axis_above" or "row=row", for example. 

  hydra_colorplot, dist(20), $
    yticks=1, ytickname=[' ',' '], xticks=1, xtickname=[' ',' '], $
    title=strtrim(index,2)
  return, ''
end
   
